/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.network;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.AbstractThreadDispatchingHandler;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.DurationUtil;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.ThreadGrouper;
import java.util.function.Consumer;
import jdk.jfr.consumer.RecordedEvent;

public final class NetworkWriteHandler
extends AbstractThreadDispatchingHandler {
    private static final String EVENT_NAME = "jdk.SocketWrite";
    private final LongHistogram bytesHistogram;
    private final DoubleHistogram durationHistogram;

    public NetworkWriteHandler(Meter meter, ThreadGrouper nameNormalizer) {
        super(nameNormalizer);
        this.bytesHistogram = meter.histogramBuilder("jvm.network.io").setDescription("Network read/write bytes.").setUnit("By").ofLongs().build();
        this.durationHistogram = meter.histogramBuilder("jvm.network.time").setDescription("Network read/write duration.").setUnit("s").build();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.NETWORK_IO_METRICS;
    }

    @Override
    public Consumer<RecordedEvent> createPerThreadSummarizer(String threadName) {
        return new PerThreadNetworkWriteHandler(this.bytesHistogram, this.durationHistogram, threadName);
    }

    private static final class PerThreadNetworkWriteHandler
    implements Consumer<RecordedEvent> {
        private static final String BYTES_WRITTEN = "bytesWritten";
        private final LongHistogram bytesHistogram;
        private final DoubleHistogram durationHistogram;
        private final Attributes attributes;

        private PerThreadNetworkWriteHandler(LongHistogram bytesHistogram, DoubleHistogram durationHistogram, String threadName) {
            this.bytesHistogram = bytesHistogram;
            this.durationHistogram = durationHistogram;
            this.attributes = Attributes.of(Constants.ATTR_THREAD_NAME, (Object)threadName, Constants.ATTR_NETWORK_MODE, (Object)"write");
        }

        @Override
        public void accept(RecordedEvent ev) {
            this.bytesHistogram.record(ev.getLong(BYTES_WRITTEN), this.attributes);
            this.durationHistogram.record(DurationUtil.toSeconds(ev.getDuration()), this.attributes);
        }
    }
}

