/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValuesManager {
    private static final ConcurrentMap<String, Key<CachedValue<?>>> globalKeyForProvider = new ConcurrentHashMap();
    private final ConcurrentMap<String, Key<CachedValue<?>>> keyForProvider = new ConcurrentHashMap();

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            CachedValuesManager.$$$reportNull$$$0(0);
        }
        return project.getService(CachedValuesManager.class);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull UserDataHolder var1, @NotNull CachedValueProvider<T> var2, boolean var3);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    protected abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull UserDataHolder var1, @NotNull ParameterizedCachedValueProvider<T, P> var2, boolean var3);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider2) {
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(1);
        }
        CachedValue<T> cachedValue = this.createCachedValue(provider2, false);
        if (cachedValue == null) {
            CachedValuesManager.$$$reportNull$$$0(2);
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, P> T getParameterizedCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider2, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value2;
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(5);
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value2 = dh.getUserData(key);
            if (value2 == null) {
                this.trackKeyHolder(dataHolder, key);
                value2 = this.createParameterizedCachedValue(dataHolder, provider2, trackValue);
                value2 = dh.putUserDataIfAbsent(key, value2);
            }
        } else {
            UserDataHolder userDataHolder = dataHolder;
            synchronized (userDataHolder) {
                value2 = dataHolder.getUserData(key);
                if (value2 == null) {
                    this.trackKeyHolder(dataHolder, key);
                    value2 = this.createParameterizedCachedValue(dataHolder, provider2, trackValue);
                    dataHolder.putUserData(key, value2);
                }
            }
        }
        return value2.getValue(parameter);
    }

    @ApiStatus.Internal
    protected abstract void trackKeyHolder(@NotNull UserDataHolder var1, @NotNull Key<?> var2);

    public abstract <T> T getCachedValue(@NotNull UserDataHolder var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull CachedValueProvider<T> provider2) {
        if (dataHolder == null) {
            CachedValuesManager.$$$reportNull$$$0(6);
        }
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(7);
        }
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider2.getClass()), provider2, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement context2, @NotNull CachedValueProvider<T> provider2) {
        if (context2 == null) {
            CachedValuesManager.$$$reportNull$$$0(8);
        }
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(9);
        }
        return CachedValuesManager.getCachedValue(context2, CachedValuesManager.getKeyForClass(provider2.getClass(), globalKeyForProvider), provider2);
    }

    public static <E extends PsiElement, T> T getProjectPsiDependentCache(@NotNull E context2, @NotNull Function<? super E, ? extends T> provider2) {
        if (context2 == null) {
            CachedValuesManager.$$$reportNull$$$0(10);
        }
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(11);
        }
        return CachedValuesManager.getCachedValue(context2, CachedValuesManager.getKeyForClass(provider2.getClass(), globalKeyForProvider), () -> {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create(provider2.apply(context2), PsiModificationTracker.MODIFICATION_COUNT);
            CachedValueProfiler.onResultCreated(result2, provider2);
            return result2;
        });
    }

    public static <T> T getCachedValue(final @NotNull PsiElement context2, @NotNull Key<CachedValue<T>> key, final @NotNull CachedValueProvider<T> provider2) {
        Getter<T> data;
        CachedValue<T> value2;
        if (context2 == null) {
            CachedValuesManager.$$$reportNull$$$0(12);
        }
        if (key == null) {
            CachedValuesManager.$$$reportNull$$$0(13);
        }
        if (provider2 == null) {
            CachedValuesManager.$$$reportNull$$$0(14);
        }
        if ((value2 = context2.getUserData(key)) != null && (data = value2.getUpToDateOrNull()) != null) {
            return data.get();
        }
        return CachedValuesManager.getManager(context2.getProject()).getCachedValue(context2, key, new CachedValueProvider<T>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<T> compute() {
                PsiFile file;
                CachedValueProvider.Result result2 = provider2.compute();
                if (result2 != null && !context2.isPhysical() && (file = context2.getContainingFile()) != null) {
                    CachedValueProvider.Result adjusted = CachedValueProvider.Result.create(result2.getValue(), ArrayUtil.append(result2.getDependencyItems(), file, ArrayUtil.OBJECT_ARRAY_FACTORY));
                    CachedValueProfiler.onResultCreated(adjusted, result2);
                    return adjusted;
                }
                return result2;
            }

            public String toString() {
                return provider2.toString();
            }
        }, false);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(15);
        }
        return CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue<?>>> keyForProvider) {
        String name2;
        Key key;
        if (providerClass == null) {
            CachedValuesManager.$$$reportNull$$$0(16);
        }
        if ((key = (Key)keyForProvider.get(name2 = providerClass.getName())) == null) {
            key = ConcurrencyUtil.cacheOrGet(keyForProvider, name2, Key.create(name2));
        }
        Key key2 = key;
        if (key2 == null) {
            CachedValuesManager.$$$reportNull$$$0(17);
        }
        return key2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/CachedValuesManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedValue";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyForClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCachedValue";
                break;
            }
            case 2: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParameterizedCachedValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPsiDependentCache";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getKeyForClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

