/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassMember;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSymbol;
import org.jetbrains.kotlin.incremental.classpathDiff.PackageMember;
import org.jetbrains.kotlin.incremental.classpathDiff.ProgramSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019BK\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0006\u0010\u0018\u001a\u00020\u0007R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet;", "", "classes", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classMembers", "", "", "packageMembers", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "getClasses", "()Ljava/util/Set;", "getClassMembers", "()Ljava/util/Map;", "getPackageMembers", "isEmpty", "", "plus", "other", "asSequence", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbol;", "toDebugString", "Collector", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nProgramSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,197:1\n168#2,3:198\n216#2,2:201\n216#2,2:203\n216#2,2:205\n216#2,2:207\n*S KotlinDebug\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet\n*L\n40#1:198,3\n47#1:201,2\n48#1:203,2\n50#1:205,2\n51#1:207,2\n*E\n"})
public final class ProgramSymbolSet {
    @NotNull
    private final Set<ClassId> classes;
    @NotNull
    private final Map<ClassId, Set<String>> classMembers;
    @NotNull
    private final Map<FqName, Set<String>> packageMembers;

    private ProgramSymbolSet(Set<ClassId> classes, Map<ClassId, ? extends Set<String>> classMembers, Map<FqName, ? extends Set<String>> packageMembers) {
        this.classes = classes;
        this.classMembers = classMembers;
        this.packageMembers = packageMembers;
    }

    @NotNull
    public final Set<ClassId> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Map<ClassId, Set<String>> getClassMembers() {
        return this.classMembers;
    }

    @NotNull
    public final Map<FqName, Set<String>> getPackageMembers() {
        return this.packageMembers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty() {
        Map.Entry<Object, Set<String>> it;
        boolean bl;
        if (!this.classes.isEmpty()) return false;
        Map<Object, Set<String>> $this$all$iv = this.classMembers;
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            bl = true;
        } else {
            for (Map.Entry<ClassId, Set<String>> entry : $this$all$iv.entrySet()) {
                it = entry;
                boolean bl2 = false;
                if (it.getValue().isEmpty()) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        $this$all$iv = this.packageMembers;
        $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator<Map.Entry<Object, Set<String>>> iterator2 = $this$all$iv.entrySet().iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Map.Entry<Object, Set<String>> entry = iterator2.next();
            it = entry;
            boolean bl3 = false;
        } while (it.getValue().isEmpty());
        return false;
    }

    @NotNull
    public final ProgramSymbolSet plus(@NotNull ProgramSymbolSet other) {
        Map.Entry<ClassId, Set<String>> it;
        Map.Entry<Object, Set<String>> element$iv;
        Intrinsics.checkNotNullParameter(other, "other");
        Collector $this$plus_u24lambda_u240 = new Collector();
        boolean bl = false;
        $this$plus_u24lambda_u240.addClasses((Collection<ClassId>)this.classes);
        $this$plus_u24lambda_u240.addClasses((Collection<ClassId>)other.classes);
        Map<Object, Set<String>> $this$forEach$iv = this.classMembers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Object, Set<String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$plus_u24lambda_u240.addClassMembers(it.getKey(), (Collection<String>)it.getValue());
        }
        $this$forEach$iv = other.classMembers;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl3 = false;
            $this$plus_u24lambda_u240.addClassMembers(it.getKey(), (Collection<String>)it.getValue());
        }
        $this$forEach$iv = this.packageMembers;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl4 = false;
            $this$plus_u24lambda_u240.addPackageMembers((FqName)((Object)it.getKey()), (Collection<String>)it.getValue());
        }
        $this$forEach$iv = other.packageMembers;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl5 = false;
            $this$plus_u24lambda_u240.addPackageMembers((FqName)((Object)it.getKey()), (Collection<String>)it.getValue());
        }
        return $this$plus_u24lambda_u240.getResult();
    }

    @NotNull
    public final Sequence<ProgramSymbol> asSequence() {
        return SequencesKt.plus(SequencesKt.plus(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.classes), ProgramSymbolSet::asSequence$lambda$0), SequencesKt.flatMap(MapsKt.asSequence(this.classMembers), ProgramSymbolSet::asSequence$lambda$1)), SequencesKt.flatMap(MapsKt.asSequence(this.packageMembers), ProgramSymbolSet::asSequence$lambda$2));
    }

    @NotNull
    public final String toDebugString() {
        return Reflection.getOrCreateKotlinClass(ProgramSymbolSet.class).getSimpleName() + "(classes = " + this.classes + ", classMembers = " + this.classMembers + ", packageMembers = " + this.packageMembers + ')';
    }

    private static final ClassSymbol asSequence$lambda$0(ClassId it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ClassSymbol(it);
    }

    private static final Sequence asSequence$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        ClassId classId = (ClassId)entry.getKey();
        Set memberNames = (Set)entry.getValue();
        return SequencesKt.map(CollectionsKt.asSequence(memberNames), arg_0 -> ProgramSymbolSet.asSequence$lambda$1$0(classId, arg_0));
    }

    private static final ClassMember asSequence$lambda$1$0(ClassId $classId, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ClassMember($classId, it);
    }

    private static final Sequence asSequence$lambda$2(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        FqName packageFqName = (FqName)entry.getKey();
        Set memberNames = (Set)entry.getValue();
        return SequencesKt.map(CollectionsKt.asSequence(memberNames), arg_0 -> ProgramSymbolSet.asSequence$lambda$2$0(packageFqName, arg_0));
    }

    private static final PackageMember asSequence$lambda$2$0(FqName $packageFqName, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new PackageMember($packageFqName, it);
    }

    public /* synthetic */ ProgramSymbolSet(Set classes, Map classMembers, Map packageMembers, DefaultConstructorMarker $constructor_marker) {
        this(classes, classMembers, packageMembers);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u001c\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u001c\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0014\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0016\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\tJ\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet$Collector;", "", "<init>", "()V", "classes", "", "Lorg/jetbrains/kotlin/name/ClassId;", "classMembers", "", "", "packageMembers", "Lorg/jetbrains/kotlin/name/FqName;", "addClass", "", "classId", "addClassMembers", "memberNames", "", "addPackageMembers", "packageFqName", "addClasses", "classIds", "addClassMember", "memberName", "getResult", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet;", "incremental-compilation-impl"})
    @SourceDebugExtension(value={"SMAP\nProgramSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet$Collector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n382#2,7:198\n382#2,7:205\n1869#3,2:212\n*S KotlinDebug\n*F\n+ 1 ProgramSymbol.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ProgramSymbolSet$Collector\n*L\n86#1:198,7\n92#1:205,7\n96#1:212,2\n*E\n"})
    public static final class Collector {
        @NotNull
        private final Set<ClassId> classes = new LinkedHashSet();
        @NotNull
        private final Map<ClassId, Set<String>> classMembers = new LinkedHashMap();
        @NotNull
        private final Map<FqName, Set<String>> packageMembers = new LinkedHashMap();

        public final void addClass(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            this.classMembers.remove(classId);
            this.classes.add(classId);
        }

        /*
         * WARNING - void declaration
         */
        public final void addClassMembers(@NotNull ClassId classId, @NotNull Collection<String> memberNames) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Intrinsics.checkNotNullParameter(memberNames, "memberNames");
            if (!this.classes.contains(classId) && !memberNames.isEmpty()) {
                Object object;
                void $this$getOrPut$iv;
                Map<ClassId, Set<String>> map = this.classMembers;
                ClassId key$iv = classId;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(memberNames);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addPackageMembers(@NotNull FqName packageFqName, @NotNull Collection<String> memberNames) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(memberNames, "memberNames");
            if (!memberNames.isEmpty()) {
                Object object;
                void $this$getOrPut$iv;
                Map<FqName, Set<String>> map = this.packageMembers;
                FqName key$iv = packageFqName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).addAll(memberNames);
            }
        }

        public final void addClasses(@NotNull Collection<ClassId> classIds) {
            Intrinsics.checkNotNullParameter(classIds, "classIds");
            Iterable $this$forEach$iv = classIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassId it = (ClassId)element$iv;
                boolean bl = false;
                this.addClass(it);
            }
        }

        public final void addClassMember(@NotNull ClassId classId, @NotNull String memberName) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            Intrinsics.checkNotNullParameter(memberName, "memberName");
            this.addClassMembers(classId, (Collection<String>)SetsKt.setOf(memberName));
        }

        @NotNull
        public final ProgramSymbolSet getResult() {
            return new ProgramSymbolSet(this.classes, this.classMembers, this.packageMembers, null);
        }
    }
}

