/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Scanner;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

final class TJDecomp {
    static final String CLASS_NAME = new TJDecomp().getClass().getName();
    private static String tjErrorMsg;
    private static int tjErrorCode;

    private TJDecomp() {
    }

    private static boolean isCropped(Rectangle rectangle) {
        return rectangle.x != 0 || rectangle.y != 0 || rectangle.width != 0 || rectangle.height != 0;
    }

    static void handleTJException(TJException tJException, int n) throws TJException {
        String string = tJException.getMessage();
        int n2 = tJException.getErrorCode();
        if (n != 1 && n2 == 0) {
            if (tjErrorMsg == null || !tjErrorMsg.equals(string) || tjErrorCode != n2) {
                tjErrorMsg = string;
                tjErrorCode = n2;
                System.out.println("WARNING: " + string);
            }
        } else {
            throw tJException;
        }
    }

    static void usage() {
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        int n = tJScalingFactorArray.length;
        System.out.println("\nUSAGE: java [Java options] " + CLASS_NAME + " [options] <JPEG image> <Output image>\n");
        System.out.println("The output image will be in Windows BMP or PBMPLUS (PPM/PGM) format, depending");
        System.out.println("on the file extension.\n");
        System.out.println("GENERAL OPTIONS (CAN BE ABBREVBIATED)");
        System.out.println("-------------------------------------");
        System.out.println("-icc FILE");
        System.out.println("    Extract the ICC (International Color Consortium) color profile from the");
        System.out.println("    JPEG image to the specified file");
        System.out.println("-strict");
        System.out.println("    Treat all warnings as fatal; abort immediately if incomplete or corrupt");
        System.out.println("    data is encountered in the JPEG image, rather than trying to salvage the");
        System.out.println("    rest of the image\n");
        System.out.println("LOSSY JPEG OPTIONS (CAN BE ABBREVIATED)");
        System.out.println("---------------------------------------");
        System.out.println("-crop WxH+X+Y");
        System.out.println("    Decompress only the specified region of the JPEG image.  (W, H, X, and Y");
        System.out.println("    are the width, height, left boundary, and upper boundary of the region, all");
        System.out.println("    specified relative to the scaled image dimensions.)  If necessary, X will");
        System.out.println("    be shifted left to the nearest iMCU boundary, and W will be increased");
        System.out.println("    accordingly.");
        System.out.println("-dct fast");
        System.out.println("    Use less accurate IDCT algorithm [legacy feature]");
        System.out.println("-dct int");
        System.out.println("    Use more accurate IDCT algorithm [default]");
        System.out.println("-grayscale");
        System.out.println("    Decompress a full-color JPEG image into a grayscale output image");
        System.out.println("-maxmemory N");
        System.out.println("    Memory limit (in megabytes) for intermediate buffers used with progressive");
        System.out.println("    JPEG decompression [default = no limit]");
        System.out.println("-maxscans N");
        System.out.println("    Refuse to decompress progressive JPEG images that have more than N scans");
        System.out.println("-nosmooth");
        System.out.println("    Use the fastest chrominance upsampling algorithm available");
        System.out.println("-rgb");
        System.out.println("    Decompress a grayscale JPEG image into a full-color output image");
        System.out.println("-scale M/N");
        System.out.println("    Scale the width/height of the JPEG image by a factor of M/N when");
        System.out.print("    decompressing it (M/N = ");
        for (int i = 0; i < n; ++i) {
            System.out.format("%d/%d", tJScalingFactorArray[i].getNum(), tJScalingFactorArray[i].getDenom());
            if (n == 2 && i != n - 1) {
                System.out.print(" or ");
            } else if (n > 2) {
                if (i != n - 1) {
                    System.out.print(", ");
                }
                if (i == n - 2) {
                    System.out.print("or ");
                }
            }
            if (i % 8 != 0 || i == 0) continue;
            System.out.print("\n    ");
        }
        System.out.println(")\n");
        System.exit(1);
    }

    static boolean matchArg(String string, String string2, int n) {
        if (string.length() > string2.length() || string.length() < n) {
            return false;
        }
        int n2 = Math.max(string.length(), n);
        string2 = string2.substring(0, n2);
        return string.equalsIgnoreCase(string2);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        TJDecompressor tJDecompressor = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            File file;
            int n2;
            int n3;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            Rectangle rectangle = TJ.UNCROPPED;
            String string = null;
            TJScalingFactor tJScalingFactor = TJ.UNSCALED;
            byte[] byArray = null;
            Object[] objectArray = null;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                Scanner scanner;
                int n10;
                int n11;
                int n12;
                if (TJDecomp.matchArg(stringArray[n3], "-crop", 2) && n3 < stringArray.length - 1) {
                    n12 = -1;
                    int n13 = -1;
                    n11 = -1;
                    n10 = -1;
                    scanner = new Scanner(stringArray[++n3]).useDelimiter("x|X|\\+");
                    try {
                        n12 = scanner.nextInt();
                        n13 = scanner.nextInt();
                        n11 = scanner.nextInt();
                        n10 = scanner.nextInt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n12 < 1 || n13 < 1 || n11 < 0 || n10 < 0) {
                        TJDecomp.usage();
                    }
                    rectangle.width = n12;
                    rectangle.height = n13;
                    rectangle.x = n11;
                    rectangle.y = n10;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-dct", 2) && n3 < stringArray.length - 1) {
                    if (TJDecomp.matchArg(stringArray[++n3], "fast", 1)) {
                        n4 = 1;
                        continue;
                    }
                    if (TJDecomp.matchArg(stringArray[n3], "int", 1)) continue;
                    TJDecomp.usage();
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-grayscale", 2) || TJDecomp.matchArg(stringArray[n3], "-greyscale", 2)) {
                    n8 = 6;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-icc", 2) && n3 < stringArray.length - 1) {
                    string = stringArray[++n3];
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-maxscans", 5) && n3 < stringArray.length - 1) {
                    n12 = -1;
                    try {
                        n12 = Integer.parseInt(stringArray[++n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n12 < 0) {
                        TJDecomp.usage();
                    }
                    n7 = n12;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-maxmemory", 2) && n3 < stringArray.length - 1) {
                    n12 = -1;
                    try {
                        n12 = Integer.parseInt(stringArray[++n3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n12 < 0) {
                        TJDecomp.usage();
                    }
                    n6 = n12;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-nosmooth", 2)) {
                    n5 = 1;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-rgb", 2)) {
                    n8 = 0;
                    continue;
                }
                if (TJDecomp.matchArg(stringArray[n3], "-strict", 3)) {
                    n9 = 1;
                    continue;
                }
                if (!TJDecomp.matchArg(stringArray[n3], "-scale", 2) || n3 >= stringArray.length - 1) break;
                n12 = 0;
                int n14 = 0;
                n11 = 0;
                n10 = 1;
                scanner = new Scanner(stringArray[++n3]).useDelimiter("/");
                try {
                    n12 = scanner.nextInt();
                    n14 = scanner.nextInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n12 < 1 || n14 < 1) {
                    TJDecomp.usage();
                }
                TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
                for (int i = 0; i < tJScalingFactorArray.length; ++i) {
                    if ((double)n12 / (double)n14 != (double)tJScalingFactorArray[i].getNum() / (double)tJScalingFactorArray[i].getDenom()) continue;
                    tJScalingFactor = tJScalingFactorArray[i];
                    n11 = 1;
                    break;
                }
                if (n11 != 0) continue;
                TJDecomp.usage();
            }
            if (n3 != stringArray.length - 2) {
                TJDecomp.usage();
            }
            tJDecompressor = new TJDecompressor();
            if (n9 >= 0) {
                tJDecompressor.set(0, n9);
            }
            if (n5 >= 0) {
                tJDecompressor.set(9, n5);
            }
            if (n4 >= 0) {
                tJDecompressor.set(10, n4);
            }
            if (n7 >= 0) {
                tJDecompressor.set(13, n7);
            }
            if (n6 >= 0) {
                tJDecompressor.set(23, n6);
            }
            if ((n2 = (fileInputStream = new FileInputStream(file = new File(stringArray[n3++]))).available()) < 1) {
                throw new Exception("Input file contains no data");
            }
            byte[] byArray2 = new byte[n2];
            fileInputStream.read(byArray2);
            fileInputStream.close();
            fileInputStream = null;
            try {
                tJDecompressor.setSourceImage(byArray2, n2);
            }
            catch (TJException tJException) {
                TJDecomp.handleTJException(tJException, n9);
            }
            int n15 = tJDecompressor.get(4);
            int n16 = tJDecompressor.get(5);
            int n17 = tJDecompressor.get(6);
            int n18 = tJDecompressor.get(7);
            int n19 = tJDecompressor.get(8);
            if (string != null) {
                try {
                    byArray = tJDecompressor.getICCProfile();
                }
                catch (TJException tJException) {
                    TJDecomp.handleTJException(tJException, n9);
                }
                if (byArray != null) {
                    File file2 = new File(string);
                    fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byArray, 0, byArray.length);
                }
            }
            if (n8 == -1) {
                n8 = n19 == 2 ? 6 : (n19 == 3 || n19 == 4 ? 11 : 0);
            }
            if (tJDecompressor.get(15) == 0) {
                tJDecompressor.setScalingFactor(tJScalingFactor);
                n16 = tJScalingFactor.getScaled(n16);
                n17 = tJScalingFactor.getScaled(n17);
                if (TJDecomp.isCropped(rectangle)) {
                    if (n15 == -1) {
                        throw new Exception("Could not determine subsampling level of JPEG image");
                    }
                    int n20 = rectangle.x % tJScalingFactor.getScaled(TJ.getMCUWidth(n15));
                    rectangle.x -= n20;
                    rectangle.width += n20;
                    tJDecompressor.setCroppingRegion(rectangle);
                    n16 = rectangle.width;
                    n17 = rectangle.height;
                }
            }
            objectArray = n18 <= 8 ? new byte[n16 * n17 * TJ.getPixelSize(n8)] : (Object[])new short[n16 * n17 * TJ.getPixelSize(n8)];
            try {
                if (n18 <= 8) {
                    tJDecompressor.decompress8((byte[])objectArray, 0, 0, 0, n8);
                } else if (n18 <= 12) {
                    tJDecompressor.decompress12((short[])objectArray, 0, 0, 0, n8);
                } else {
                    tJDecompressor.decompress16((short[])objectArray, 0, 0, 0, n8);
                }
            }
            catch (TJException tJException) {
                TJDecomp.handleTJException(tJException, n9);
            }
            tJDecompressor.saveImage(stringArray[n3], objectArray, 0, 0, n16, 0, n17, n8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        try {
            if (tJDecompressor != null) {
                tJDecompressor.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(n);
    }

    static {
        tjErrorCode = -1;
    }
}

