/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.Rectangle;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

public final class TJ {
    public static final int NUMSAMP = 7;
    public static final int SAMP_444 = 0;
    public static final int SAMP_422 = 1;
    public static final int SAMP_420 = 2;
    public static final int SAMP_GRAY = 3;
    public static final int SAMP_440 = 4;
    public static final int SAMP_411 = 5;
    public static final int SAMP_441 = 6;
    public static final int SAMP_UNKNOWN = -1;
    private static final int[] MCU_WIDTH = new int[]{8, 16, 16, 8, 8, 32, 8};
    private static final int[] MCU_HEIGHT = new int[]{8, 8, 16, 8, 16, 8, 32};
    public static final int NUMPF = 12;
    public static final int PF_RGB = 0;
    public static final int PF_BGR = 1;
    public static final int PF_RGBX = 2;
    public static final int PF_BGRX = 3;
    public static final int PF_XBGR = 4;
    public static final int PF_XRGB = 5;
    public static final int PF_GRAY = 6;
    public static final int PF_RGBA = 7;
    public static final int PF_BGRA = 8;
    public static final int PF_ABGR = 9;
    public static final int PF_ARGB = 10;
    public static final int PF_CMYK = 11;
    public static final int PF_UNKNOWN = -1;
    private static final int[] PIXEL_SIZE = new int[]{3, 3, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4};
    private static final int[] RED_OFFSET = new int[]{0, 2, 0, 2, 3, 1, -1, 0, 2, 3, 1, -1};
    private static final int[] GREEN_OFFSET = new int[]{1, 1, 1, 1, 2, 2, -1, 1, 1, 2, 2, -1};
    private static final int[] BLUE_OFFSET = new int[]{2, 0, 2, 0, 1, 3, -1, 2, 0, 1, 3, -1};
    private static final int[] ALPHA_OFFSET = new int[]{-1, -1, -1, -1, -1, -1, -1, 3, 3, 0, 0, -1};
    public static final int NUMCS = 5;
    public static final int CS_RGB = 0;
    public static final int CS_YCbCr = 1;
    public static final int CS_GRAY = 2;
    public static final int CS_CMYK = 3;
    public static final int CS_YCCK = 4;
    public static final int PARAM_STOPONWARNING = 0;
    public static final int PARAM_BOTTOMUP = 1;
    public static final int PARAM_QUALITY = 3;
    public static final int PARAM_SUBSAMP = 4;
    public static final int PARAM_JPEGWIDTH = 5;
    public static final int PARAM_JPEGHEIGHT = 6;
    public static final int PARAM_PRECISION = 7;
    public static final int PARAM_COLORSPACE = 8;
    public static final int PARAM_FASTUPSAMPLE = 9;
    public static final int PARAM_FASTDCT = 10;
    public static final int PARAM_OPTIMIZE = 11;
    public static final int PARAM_PROGRESSIVE = 12;
    public static final int PARAM_SCANLIMIT = 13;
    public static final int PARAM_ARITHMETIC = 14;
    public static final int PARAM_LOSSLESS = 15;
    public static final int PARAM_LOSSLESSPSV = 16;
    public static final int PARAM_LOSSLESSPT = 17;
    public static final int PARAM_RESTARTBLOCKS = 18;
    public static final int PARAM_RESTARTROWS = 19;
    public static final int PARAM_XDENSITY = 20;
    public static final int PARAM_YDENSITY = 21;
    public static final int PARAM_DENSITYUNITS = 22;
    public static final int PARAM_MAXMEMORY = 23;
    public static final int PARAM_MAXPIXELS = 24;
    public static final int PARAM_SAVEMARKERS = 25;
    public static final int NUMERR = 2;
    public static final int ERR_WARNING = 0;
    public static final int ERR_FATAL = 1;
    public static final TJScalingFactor UNSCALED = new TJScalingFactor(1, 1);
    public static final Rectangle UNCROPPED = new Rectangle(0, 0, 0, 0);

    private TJ() {
    }

    public static int getMCUWidth(int n) {
        TJ.checkSubsampling(n);
        return MCU_WIDTH[n];
    }

    public static int getMCUHeight(int n) {
        TJ.checkSubsampling(n);
        return MCU_HEIGHT[n];
    }

    public static int getPixelSize(int n) {
        TJ.checkPixelFormat(n);
        return PIXEL_SIZE[n];
    }

    public static int getRedOffset(int n) {
        TJ.checkPixelFormat(n);
        return RED_OFFSET[n];
    }

    public static int getGreenOffset(int n) {
        TJ.checkPixelFormat(n);
        return GREEN_OFFSET[n];
    }

    public static int getBlueOffset(int n) {
        TJ.checkPixelFormat(n);
        return BLUE_OFFSET[n];
    }

    public static int getAlphaOffset(int n) {
        TJ.checkPixelFormat(n);
        return ALPHA_OFFSET[n];
    }

    public static native int bufSize(int var0, int var1, int var2);

    public static native int bufSizeYUV(int var0, int var1, int var2, int var3);

    public static native int planeSizeYUV(int var0, int var1, int var2, int var3, int var4);

    public static native int planeWidth(int var0, int var1, int var2);

    public static native int planeHeight(int var0, int var1, int var2);

    public static native TJScalingFactor[] getScalingFactors();

    private static void checkPixelFormat(int n) {
        if (n < 0 || n >= 12) {
            throw new IllegalArgumentException("Invalid pixel format");
        }
    }

    private static void checkSubsampling(int n) {
        if (n < 0 || n >= 7) {
            throw new IllegalArgumentException("Invalid subsampling type");
        }
    }

    static {
        TJLoader.load();
    }
}

