# Why is a CVE Not Available?
This documentation explains why sometimes you might see this message in either msfconsole or module documentation:

```
CVE: Not available
```

This message indicates that, as far as the Metasploit team knows, there is no CVE assigned to that particular module at the moment. There are multiple reasons why this might happen:

* The vendor does not wish to assign a CVE.
* There is a delay in the process of assigning a CVE.
* The module is not meant to target a specific CVE. Likely something generic.
* We are unable to find a matching CVE because there isn't enough technical information to verify.

The Metasploit team will continue to monitor existing modules without any CVEs, and update them as needed.

If you believe the module's CVE information is inaccurate or out-of-date, please feel free to [submit a pull](https://github.com/rapid7/metasploit-framework) request to us. Thank you! :-)