# -*- coding: binary -*-

module Msf
  module Exploit::Local::Persistence
    def initialize(info = {})
      @persistence_service = Rex::Sync::Event.new(auto_reset = false)
      @clean_up_rc = ''
      super(
        update_info(
          info,
          'DefaultOptions' => {},
          # https://github.com/rapid7/metasploit-framework/pull/19676#discussion_r1907594308
          'Stance' => Msf::Exploit::Stance::Passive,
          'Passive' => true
        )
      )

      register_advanced_options(
        [
          OptString.new('WritableDir', [true, 'A directory where we can write files', '']),
          OptBool.new('CleanUpRc', [true, 'Create a cleanup resource file.', true])
        ]
      )
    end

    def exploit
      run_as_background = !datastore['DisablePayloadHandler']
      print_warning('Payload handler is disabled, the persistence will be installed only.') unless run_as_background

      # Call the install_persistence function
      # must be declared inside the persistence module
      install_persistence

      save_cleanup_rc if datastore['CleanUpRc'] && !@clean_up_rc.empty?

      @persistence_service.wait if run_as_background
    end

    def writable_dir
      # base the WritableDir default off of the persistence module path to avoid
      # needing to probe the target directly, or deal with one offs like ssh sessions
      return datastore['WritableDir'] unless datastore['WritableDir'].empty?

      mod_path = self.class.file_path.downcase.tr('\\', '/')

      if mod_path.include?('/windows/')
        '%TEMP%'
      elsif mod_path.include?('/multi/')
        print_warning('Please set the WritableDir datastore option or the module is likely to fail')
        ''
      else
        '/tmp/'
      end
    end

    def install_persistence
      # to be overloaded by the module
    end

    def save_cleanup_rc
      host = session.sys.config.sysinfo['Computer']
      # Create Filename info to be appended to downloaded files
      filenameinfo = '_' + ::Time.now.strftime('%Y%m%d.%M%S')
      logs = ::File.join(Msf::Config.log_directory, 'persistence', Rex::FileUtils.clean_path(host + filenameinfo))
      # Create the log directory
      ::FileUtils.mkdir_p(logs)

      # logfile name
      clean_rc = logs + ::File::Separator + Rex::FileUtils.clean_path(host + filenameinfo) + '.rc'
      file_local_write(clean_rc, @clean_up_rc)

      print_status("Meterpreter-compatible Cleanup RC file: #{clean_rc}")

      report_note(host: host,
                  type: 'host.persistance.cleanup',
                  data: {
                    local_id: session.sid,
                    stype: session.type,
                    desc: session.info,
                    platform: session.platform,
                    via_payload: session.via_payload,
                    via_exploit: session.via_exploit,
                    created_at: Time.now.utc,
                    commands: @clean_up_rc
                  })
    end

    def cleanup
    end
  end
end
