# -*- coding:binary -*-
require 'spec_helper'

RSpec.describe Rex::Proto::Kerberos::Crypto::Asn1Utils do
  subject(:utils) do
    Class.new.extend(described_class)
  end

  it 'Correctly truncates nulls' do
    input = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c414e0000000000'].pack('H*')
    expected = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c414e'].pack('H*')
    res = utils.truncate_nulls_after_asn1(input)

    expect(res).to eq(expected)
  end

  it 'Leaves it alone if there is no padding' do
    input = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c414e'].pack('H*')
    expected = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c414e'].pack('H*')
    res = utils.truncate_nulls_after_asn1(input)

    expect(res).to eq(expected)
  end

  it "Doesn't truncate too many nulls" do
    input = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c41000000000000'].pack('H*')
    expected = ['7981d03081cda0133011a003020103a10a040898618a6b2c37fbbaa11c301a3018a003020100a111180f32303232303632313030313735315aa2050203090425a311180f32303337303931343032343830355aa40703050050e10000a511180f32303232303632313030313735315aa611180f32303232303632313030313735315aa711180f32303232303632313130313735315aa811180f32303232303632323030313830305aa90a1b08414243442e4c414eaa1d301ba003020101a11430121b066b72627467741b08414243442e4c4100'].pack('H*')
    res = utils.truncate_nulls_after_asn1(input)

    expect(res).to eq(expected)
  end
end
