#! /bin/bash

if (( $# == 1 )); then
if [ "x$1" == "x-h" ]; then
echo "usage: cmd_cache <device name>"
exit 0
else
dev=$1
fi
elif (( $# == 0 )); then
dev=$(ls /sys/class/infiniband/ | grep mlx5 | head -1)
else
echo "usage: cmd_cache <device name>"
exit -1
fi

dirs=$(ls /sys/class/infiniband/${dev}/device/commands_cache/ | sort -g)

rm=$(cat /sys/class/infiniband/${dev}/device/real_miss)
echo "real miss count: $rm"
printf "cmd size\tnum ent\ttotal\tfree\tmiss\n"
for dir in $dirs; do
nent=$(cat /sys/class/infiniband/${dev}/device/commands_cache/$dir/num_ent)
tot=$(cat /sys/class/infiniband/${dev}/device/commands_cache/$dir/total_commands)
free=$(cat /sys/class/infiniband/${dev}/device/commands_cache/$dir/free)
miss=$(cat /sys/class/infiniband/${dev}/device/commands_cache/$dir/miss)
printf "$dir\t\t$nent\t$tot\t$free\t$miss\n"
done
