/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.util;

import java.util.Map;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.annotation.PublicApi;

@PublicApi(since="3.0.0")
public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static String readOptionalStringProperty(Map<String, Object> configuration, String propertyName) {
        Object value = configuration.get(propertyName);
        return ConfigurationUtils.readString(propertyName, value);
    }

    public static String readStringProperty(Map<String, Object> configuration, String propertyName) {
        return ConfigurationUtils.readStringProperty(configuration, propertyName, null);
    }

    public static String readStringProperty(Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.get(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(propertyName, "required property is missing");
        }
        return ConfigurationUtils.readString(propertyName, value);
    }

    public static OpenSearchException newConfigurationException(String propertyName, String reason) {
        Object msg = propertyName == null ? reason : "[" + propertyName + "] " + reason;
        OpenSearchParseException exception = new OpenSearchParseException((String)msg, new Object[0]);
        ConfigurationUtils.addMetadataToException(exception, propertyName);
        return exception;
    }

    private static String readString(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ConfigurationUtils.newConfigurationException(propertyName, "property isn't a string, but of type [" + value.getClass().getName() + "]");
    }

    private static void addMetadataToException(OpenSearchException exception, String propertyName) {
        if (propertyName != null) {
            exception.addMetadata("opensearch.property_name", propertyName);
        }
    }

    public static String readStringOrIntProperty(Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.get(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(propertyName, "required property is missing");
        }
        return ConfigurationUtils.readStringOrInt(propertyName, value);
    }

    private static String readStringOrInt(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            return String.valueOf(value);
        }
        throw ConfigurationUtils.newConfigurationException(propertyName, "property isn't a string or int, but of type [" + value.getClass().getName() + "]");
    }

    public static String readOptionalStringOrIntProperty(Map<String, Object> configuration, String propertyName) {
        Object value = configuration.get(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readStringOrInt(propertyName, value);
    }

    public static boolean readBooleanProperty(Map<String, Object> configuration, String propertyName, boolean defaultValue) {
        Object value = configuration.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return ConfigurationUtils.readBoolean(propertyName, value);
    }

    private static Boolean readBoolean(String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        throw ConfigurationUtils.newConfigurationException(propertyName, "property isn't a boolean, but of type [" + value.getClass().getName() + "]");
    }

    public static Integer readIntProperty(Map<String, Object> configuration, String propertyName, Integer defaultValue) {
        Object value = configuration.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(propertyName, "property cannot be converted to an int [" + String.valueOf(value) + "]");
        }
    }

    public static Double readDoubleProperty(Map<String, Object> configuration, String propertyName) {
        Object value = configuration.get(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(propertyName, "required property is missing");
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(propertyName, "property cannot be converted to a double [" + String.valueOf(value) + "]");
        }
    }
}

