/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.Processor;

public final class JsonProcessor
extends AbstractProcessor {
    public static final String TYPE = "json";
    private final String field;
    private final String targetField;
    private final boolean addToRoot;

    JsonProcessor(String tag, String description, String field, String targetField, boolean addToRoot) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.addToRoot = addToRoot;
    }

    public String getField() {
        return this.field;
    }

    public String getTargetField() {
        return this.targetField;
    }

    boolean isAddToRoot() {
        return this.addToRoot;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object apply(Object fieldValue) {
        BytesArray bytesRef = fieldValue == null ? new BytesArray("null") : new BytesArray(fieldValue.toString());
        try (StreamInput stream = bytesRef.streamInput();){
            String string;
            block27: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                try {
                    XContentParser.Token token = parser.nextToken();
                    Object value = null;
                    if (token == XContentParser.Token.VALUE_NULL) {
                        value = null;
                    } else if (token == XContentParser.Token.VALUE_STRING) {
                        value = parser.text();
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        value = parser.numberValue();
                    } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        value = parser.booleanValue();
                    } else if (token == XContentParser.Token.START_OBJECT) {
                        value = parser.map();
                    } else if (token == XContentParser.Token.START_ARRAY) {
                        value = parser.list();
                    } else if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                        throw new IllegalArgumentException("cannot read binary value");
                    }
                    string = value;
                    if (parser == null) break block27;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void apply(Map<String, Object> ctx, String fieldName) {
        Object value = JsonProcessor.apply(ctx.get(fieldName));
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("cannot add non-map fields to root of document");
        }
        Map map = (Map)value;
        ctx.putAll(map);
    }

    public IngestDocument execute(IngestDocument document) throws Exception {
        if (this.addToRoot) {
            JsonProcessor.apply(document.getSourceAndMetadata(), this.field);
        } else {
            document.setFieldValue(this.targetField, JsonProcessor.apply(document.getFieldValue(this.field, Object.class)));
        }
        return document;
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        public JsonProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String field = ConfigurationUtils.readStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readOptionalStringProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"target_field");
            boolean addToRoot = ConfigurationUtils.readBooleanProperty((String)JsonProcessor.TYPE, (String)processorTag, config, (String)"add_to_root", (boolean)false);
            if (addToRoot && targetField != null) {
                throw ConfigurationUtils.newConfigurationException((String)JsonProcessor.TYPE, (String)processorTag, (String)"target_field", (String)"Cannot set a target field while also setting `add_to_root` to true");
            }
            if (targetField == null) {
                targetField = field;
            }
            return new JsonProcessor(processorTag, description, field, targetField, addToRoot);
        }
    }
}

