/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValuesSource;

public final class SimpleBindings
extends Bindings {
    private final Map<String, Function<Bindings, DoubleValuesSource>> map = new HashMap<String, Function<Bindings, DoubleValuesSource>>();

    public void add(String name, DoubleValuesSource source) {
        this.map.put(name, bindings -> source);
    }

    public void add(String name, Expression expression) {
        this.map.put(name, expression::getDoubleValuesSource);
    }

    @Override
    public DoubleValuesSource getDoubleValuesSource(String name) {
        if (!this.map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid reference '" + name + "'");
        }
        return this.map.get(name).apply(this);
    }

    public void validate() {
        for (Map.Entry<String, Function<Bindings, DoubleValuesSource>> origin : this.map.entrySet()) {
            origin.getValue().apply(new CycleDetectionBindings(origin.getKey()));
        }
    }

    private class CycleDetectionBindings
    extends Bindings {
        private final Set<String> seenFields = new LinkedHashSet<String>();

        CycleDetectionBindings(String current) {
            this.seenFields.add(current);
        }

        CycleDetectionBindings(Set<String> parents, String current) {
            this.seenFields.addAll(parents);
            this.seenFields.add(current);
        }

        @Override
        public DoubleValuesSource getDoubleValuesSource(String name) {
            if (this.seenFields.contains(name)) {
                throw new IllegalArgumentException("Recursion error: Cycle detected " + String.valueOf(this.seenFields) + "->" + name);
            }
            if (!SimpleBindings.this.map.containsKey(name)) {
                throw new IllegalArgumentException("Invalid reference '" + name + "'");
            }
            return SimpleBindings.this.map.get(name).apply(new CycleDetectionBindings(this.seenFields, name));
        }
    }
}

