/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;

@ExperimentalApi
public class UpdateRuleRequest
extends ActionRequest {
    private final String id;
    private final String description;
    private final Map<Attribute, Set<String>> attributeMap;
    private final String featureValue;
    private final FeatureType featureType;

    public UpdateRuleRequest(String id, String description, Map<Attribute, Set<String>> attributeMap, String featureValue, FeatureType featureType) {
        this.id = id;
        this.description = description;
        this.attributeMap = attributeMap;
        this.featureValue = featureValue;
        this.featureType = featureType;
    }

    public UpdateRuleRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.description = in.readOptionalString();
        this.featureType = FeatureType.from(in);
        this.attributeMap = in.readMap(i -> Attribute.from(i, this.featureType), i -> new HashSet(i.readStringList()));
        this.featureValue = in.readOptionalString();
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeOptionalString(this.description);
        this.featureType.writeTo(out);
        out.writeMap(this.attributeMap, (o, a) -> a.writeTo(o), StreamOutput::writeStringCollection);
        out.writeOptionalString(this.featureValue);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<Attribute, Set<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public String getFeatureValue() {
        return this.featureValue;
    }
}

