/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.common;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.opensearch.protobufs.FieldValue;
import org.opensearch.protobufs.GeneralNumber;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.transport.grpc.proto.response.common.ObjectMapProtoUtils;

public class FieldValueProtoUtils {
    private FieldValueProtoUtils() {
    }

    public static FieldValue toProto(Object javaObject) {
        FieldValue.Builder fieldValueBuilder = FieldValue.newBuilder();
        FieldValueProtoUtils.toProto(javaObject, fieldValueBuilder);
        return fieldValueBuilder.build();
    }

    public static void toProto(Object javaObject, FieldValue.Builder fieldValueBuilder) {
        if (javaObject == null) {
            throw new IllegalArgumentException("Cannot convert null to FieldValue");
        }
        Object object = javaObject;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, Enum.class, Map.class}, (Object)object2, n)) {
            case 0: {
                String s = (String)object2;
                fieldValueBuilder.setStringValue(s);
                break;
            }
            case 1: {
                Integer i = (Integer)object2;
                fieldValueBuilder.setGeneralNumber(GeneralNumber.newBuilder().setInt32Value(i.intValue()).build());
                break;
            }
            case 2: {
                Long l = (Long)object2;
                fieldValueBuilder.setGeneralNumber(GeneralNumber.newBuilder().setInt64Value(l.longValue()).build());
                break;
            }
            case 3: {
                Double d = (Double)object2;
                fieldValueBuilder.setGeneralNumber(GeneralNumber.newBuilder().setDoubleValue(d.doubleValue()).build());
                break;
            }
            case 4: {
                Float f = (Float)object2;
                fieldValueBuilder.setGeneralNumber(GeneralNumber.newBuilder().setFloatValue(f.floatValue()).build());
                break;
            }
            case 5: {
                Boolean b = (Boolean)object2;
                fieldValueBuilder.setBoolValue(b.booleanValue());
                break;
            }
            case 6: {
                Enum e = (Enum)object2;
                fieldValueBuilder.setStringValue(e.toString());
                break;
            }
            case 7: {
                Map m;
                Map map = m = (Map)object2;
                FieldValueProtoUtils.handleMapValue(map, fieldValueBuilder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert " + String.valueOf(javaObject) + " to FieldValue");
            }
        }
    }

    private static void handleMapValue(Map<String, Object> map, FieldValue.Builder fieldValueBuilder) {
        ObjectMap.Builder objectMapBuilder = ObjectMap.newBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            objectMapBuilder.putFields(entry.getKey(), ObjectMapProtoUtils.toProto(entry.getValue()));
        }
        fieldValueBuilder.setObjectMap(objectMapBuilder.build());
    }
}

