/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchContextIdForNode;
import org.opensearch.action.search.SearchScrollAsyncAction;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.search.TransportSearchHelper;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.util.concurrent.CountDown;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.Transport;

public final class ClearScrollController
implements Runnable {
    private final DiscoveryNodes nodes;
    private final SearchTransportService searchTransportService;
    private final CountDown expectedOps;
    private final ActionListener<ClearScrollResponse> listener;
    private final AtomicBoolean hasFailed = new AtomicBoolean(false);
    private final AtomicInteger freedSearchContexts = new AtomicInteger(0);
    private final Logger logger;
    private final Runnable runner;

    ClearScrollController(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener, DiscoveryNodes nodes, Logger logger, SearchTransportService searchTransportService) {
        int expectedOps;
        this.nodes = nodes;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.listener = listener;
        List<String> scrollIds = request.getScrollIds();
        if (scrollIds.size() == 1 && "_all".equals(scrollIds.get(0))) {
            expectedOps = nodes.getSize();
            this.runner = this::cleanAllScrolls;
        } else {
            ArrayList contexts = new ArrayList();
            for (String scrollId : request.getScrollIds()) {
                SearchContextIdForNode[] context = TransportSearchHelper.parseScrollId(scrollId).getContext();
                Collections.addAll(contexts, context);
            }
            if (contexts.isEmpty()) {
                expectedOps = 0;
                this.runner = () -> listener.onResponse((Object)new ClearScrollResponse(true, 0));
            } else {
                expectedOps = contexts.size();
                this.runner = () -> this.cleanScrollIds(contexts);
            }
        }
        this.expectedOps = new CountDown(expectedOps);
    }

    @Override
    public void run() {
        this.runner.run();
    }

    void cleanAllScrolls() {
        for (final DiscoveryNode node : this.nodes) {
            try {
                Transport.Connection connection = this.searchTransportService.getConnection(null, node);
                this.searchTransportService.sendClearAllScrollContexts(connection, new ActionListener<TransportResponse>(){

                    public void onResponse(TransportResponse response) {
                        ClearScrollController.this.onFreedContext(true);
                    }

                    public void onFailure(Exception e) {
                        ClearScrollController.this.onFailedFreedContext(e, node);
                    }
                });
            }
            catch (Exception e) {
                this.onFailedFreedContext(e, node);
            }
        }
    }

    void cleanScrollIds(List<SearchContextIdForNode> contextIds) {
        SearchScrollAsyncAction.collectNodesAndRun(contextIds, this.nodes, this.searchTransportService, (ActionListener<BiFunction<String, String, DiscoveryNode>>)ActionListener.wrap(lookup -> {
            for (SearchContextIdForNode target : contextIds) {
                DiscoveryNode node = (DiscoveryNode)lookup.apply(target.getClusterAlias(), target.getNode());
                if (node == null) {
                    this.onFreedContext(false);
                    continue;
                }
                try {
                    Transport.Connection connection = this.searchTransportService.getConnection(target.getClusterAlias(), node);
                    this.searchTransportService.sendFreeContext(connection, target.getSearchContextId(), (ActionListener<SearchTransportService.SearchFreeContextResponse>)ActionListener.wrap(freed -> this.onFreedContext(freed.isFreed()), e -> this.onFailedFreedContext((Throwable)e, node)));
                }
                catch (Exception e2) {
                    this.onFailedFreedContext(e2, node);
                }
            }
        }, arg_0 -> this.listener.onFailure(arg_0)));
    }

    private void onFreedContext(boolean freed) {
        if (freed) {
            this.freedSearchContexts.incrementAndGet();
        }
        if (this.expectedOps.countDown()) {
            boolean succeeded = !this.hasFailed.get();
            this.listener.onResponse((Object)new ClearScrollResponse(succeeded, this.freedSearchContexts.get()));
        }
    }

    private void onFailedFreedContext(Throwable e, DiscoveryNode node) {
        this.logger.warn(() -> new ParameterizedMessage("Clear SC failed on node[{}]", (Object)node), e);
        this.hasFailed.set(true);
        if (this.expectedOps.countDown()) {
            this.listener.onResponse((Object)new ClearScrollResponse(false, this.freedSearchContexts.get()));
        }
    }

    public static void closeContexts(DiscoveryNodes nodes, SearchTransportService searchTransportService, Collection<SearchContextIdForNode> contextIds, ActionListener<Integer> listener) {
        if (contextIds.isEmpty()) {
            listener.onResponse((Object)0);
            return;
        }
        Set<String> clusters = contextIds.stream().filter(ctx -> !Strings.isEmpty((CharSequence)ctx.getClusterAlias())).map(SearchContextIdForNode::getClusterAlias).collect(Collectors.toSet());
        StepListener lookupListener = new StepListener();
        if (!clusters.isEmpty()) {
            searchTransportService.getRemoteClusterService().collectNodes(clusters, (ActionListener<BiFunction<String, String, DiscoveryNode>>)lookupListener);
        } else {
            lookupListener.onResponse((cluster, nodeId) -> nodes.get((String)nodeId));
        }
        lookupListener.whenComplete(nodeLookup -> {
            GroupedActionListener<Boolean> groupedListener = new GroupedActionListener<Boolean>(ActionListener.delegateFailure((ActionListener)listener, (l, rs) -> l.onResponse((Object)Math.toIntExact(rs.stream().filter(r -> r).count()))), contextIds.size());
            for (SearchContextIdForNode contextId : contextIds) {
                DiscoveryNode node = (DiscoveryNode)nodeLookup.apply(contextId.getClusterAlias(), contextId.getNode());
                if (node == null) {
                    groupedListener.onResponse(false);
                    continue;
                }
                try {
                    Transport.Connection connection = searchTransportService.getConnection(contextId.getClusterAlias(), node);
                    searchTransportService.sendFreeContext(connection, contextId.getSearchContextId(), (ActionListener<SearchTransportService.SearchFreeContextResponse>)ActionListener.wrap(r -> groupedListener.onResponse(r.isFreed()), e -> groupedListener.onResponse(false)));
                }
                catch (Exception e2) {
                    groupedListener.onResponse(false);
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

