/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class View
extends AbstractDiffable<View>
implements ToXContentObject {
    private final String name;
    private final String description;
    private final long createdAt;
    private final long modifiedAt;
    private final SortedSet<Target> targets;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField DESCRIPTION_FIELD = new ParseField("description", new String[0]);
    public static final ParseField CREATED_AT_FIELD = new ParseField("createdAt", new String[0]);
    public static final ParseField MODIFIED_AT_FIELD = new ParseField("modifiedAt", new String[0]);
    public static final ParseField TARGETS_FIELD = new ParseField("targets", new String[0]);
    public static final ConstructingObjectParser<View, Void> PARSER = new ConstructingObjectParser("view", args -> new View((String)args[0], (String)args[1], (Long)args[2], (Long)args[3], new TreeSet<Target>((List)args[4])));

    public View(String name, String description, Long createdAt, Long modifiedAt, Set<Target> targets) {
        this.name = Objects.requireNonNull(name, "Name must be provided");
        this.description = description;
        this.createdAt = createdAt != null ? createdAt : -1L;
        this.modifiedAt = modifiedAt != null ? modifiedAt : -1L;
        this.targets = new TreeSet<Target>((Collection)Objects.requireNonNull(targets, "Targets are required on a view"));
    }

    public View(StreamInput in) throws IOException {
        this(in.readString(), in.readOptionalString(), in.readZLong(), in.readZLong(), new TreeSet<Target>(in.readList(Target::new)));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public SortedSet<Target> getTargets() {
        return new TreeSet<Target>(this.targets);
    }

    public static Diff<View> readDiffFrom(StreamInput in) throws IOException {
        return View.readDiffFrom(View::new, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View that = (View)o;
        return this.name.equals(that.name) && this.description.equals(that.description) && this.createdAt == that.createdAt && this.modifiedAt == that.modifiedAt && this.targets.equals(that.targets);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.createdAt, this.modifiedAt, this.targets);
    }

    public static View fromXContent(XContentParser parser) throws IOException {
        return (View)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(DESCRIPTION_FIELD.getPreferredName(), this.description);
        builder.field(CREATED_AT_FIELD.getPreferredName(), this.createdAt);
        builder.field(MODIFIED_AT_FIELD.getPreferredName(), this.modifiedAt);
        builder.field(TARGETS_FIELD.getPreferredName(), this.targets);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.description);
        out.writeZLong(this.createdAt);
        out.writeZLong(this.modifiedAt);
        out.writeList(this.targets.stream().collect(Collectors.toList()));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION_FIELD);
        PARSER.declareLongOrNull(ConstructingObjectParser.optionalConstructorArg(), -1L, CREATED_AT_FIELD);
        PARSER.declareLongOrNull(ConstructingObjectParser.optionalConstructorArg(), -1L, MODIFIED_AT_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Target.fromXContent(p), TARGETS_FIELD);
    }

    @ExperimentalApi
    public static class Target
    implements Writeable,
    ToXContentObject,
    Comparable<Target> {
        private final String indexPattern;
        public static final ParseField INDEX_PATTERN_FIELD = new ParseField("indexPattern", new String[0]);
        private static final ConstructingObjectParser<Target, Void> PARSER = new ConstructingObjectParser("target", args -> new Target((String)args[0]));

        public Target(String indexPattern) {
            this.indexPattern = Objects.requireNonNull(indexPattern, "IndexPattern is required");
        }

        public Target(StreamInput in) throws IOException {
            this(in.readString());
        }

        public String getIndexPattern() {
            return this.indexPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target that = (Target)o;
            return this.indexPattern.equals(that.indexPattern);
        }

        public int hashCode() {
            return Objects.hash(this.indexPattern);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_PATTERN_FIELD.getPreferredName(), this.indexPattern);
            builder.endObject();
            return builder;
        }

        public static Target fromXContent(XContentParser parser) throws IOException {
            return (Target)PARSER.parse(parser, null);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexPattern);
        }

        @Override
        public int compareTo(Target o) {
            if (this == o) {
                return 0;
            }
            Target other = o;
            return this.indexPattern.compareTo(other.indexPattern);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_PATTERN_FIELD);
        }
    }
}

