/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.View;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class ViewMetadata
implements Metadata.Custom {
    public static final String TYPE = "view";
    private static final ParseField VIEW_FIELD = new ParseField("view", new String[0]);
    private static final ConstructingObjectParser<ViewMetadata, Void> PARSER = new ConstructingObjectParser("view", false, a -> new ViewMetadata((Map)a[0]));
    private final Map<String, View> views;

    public ViewMetadata(Map<String, View> views) {
        this.views = views;
    }

    public ViewMetadata(StreamInput in) throws IOException {
        this.views = in.readMap(StreamInput::readString, View::new);
    }

    public Map<String, View> views() {
        return this.views;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new ViewMetadataDiff((ViewMetadata)before, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ViewMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return ComposableIndexTemplateMetadata.MINIMMAL_SUPPORTED_VERSION;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.views, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public static ViewMetadata fromXContent(XContentParser parser) throws IOException {
        return (ViewMetadata)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(VIEW_FIELD.getPreferredName());
        for (Map.Entry<String, View> entry : this.views.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
        builder.endObject();
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.views);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ViewMetadata other = (ViewMetadata)obj;
        return Objects.equals(this.views, other.views);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, View> views = new HashMap<String, View>();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                views.put(p.currentName(), View.fromXContent(p));
            }
            return views;
        }, VIEW_FIELD);
    }

    static class ViewMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, View>> dataStreamDiff;

        ViewMetadataDiff(ViewMetadata before, ViewMetadata after) {
            this.dataStreamDiff = DiffableUtils.diff(before.views, after.views, DiffableUtils.getStringKeySerializer());
        }

        ViewMetadataDiff(StreamInput in) throws IOException {
            this.dataStreamDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), View::new, View::readDiffFrom);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new ViewMetadata(this.dataStreamDiff.apply(((ViewMetadata)part).views));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.dataStreamDiff.writeTo(out);
        }

        public String getWriteableName() {
            return ViewMetadata.TYPE;
        }
    }

    @ExperimentalApi
    public static class Builder {
        private final Map<String, View> views = new HashMap<String, View>();

        public Builder putDataStream(View view) {
            this.views.put(view.getName(), view);
            return this;
        }

        public ViewMetadata build() {
            return new ViewMetadata(this.views);
        }
    }
}

