/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.WorkloadGroup;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class WorkloadGroupMetadata
implements Metadata.Custom {
    public static final String TYPE = "queryGroups";
    private static final ParseField WORKLOAD_GROUP_FIELD = new ParseField("queryGroups", new String[0]);
    private final Map<String, WorkloadGroup> workloadGroups;

    public WorkloadGroupMetadata(Map<String, WorkloadGroup> workloadGroups) {
        this.workloadGroups = workloadGroups;
    }

    public WorkloadGroupMetadata(StreamInput in) throws IOException {
        this.workloadGroups = in.readMap(StreamInput::readString, WorkloadGroup::new);
    }

    public Map<String, WorkloadGroup> workloadGroups() {
        return this.workloadGroups;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_3_0_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.workloadGroups, StreamOutput::writeString, (stream, val) -> val.writeTo(stream));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, WorkloadGroup> entry : this.workloadGroups.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
        return builder;
    }

    public static WorkloadGroupMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, WorkloadGroup> workloadGroupMap = new HashMap<String, WorkloadGroup>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("WorkloadGroupMetadata.fromXContent was expecting a { token but found : " + String.valueOf(parser.currentToken()));
        }
        XContentParser.Token token = parser.currentToken();
        String fieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            WorkloadGroup workloadGroup = WorkloadGroup.fromXContent(parser);
            workloadGroupMap.put(fieldName, workloadGroup);
        }
        return new WorkloadGroupMetadata(workloadGroupMap);
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new WorkloadGroupMetadataDiff((WorkloadGroupMetadata)previousState, this);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new WorkloadGroupMetadataDiff(in);
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadGroupMetadata that = (WorkloadGroupMetadata)o;
        return Objects.equals(this.workloadGroups, that.workloadGroups);
    }

    public int hashCode() {
        return Objects.hash(this.workloadGroups);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static class WorkloadGroupMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, WorkloadGroup>> dataStreamDiff;

        WorkloadGroupMetadataDiff(WorkloadGroupMetadata before, WorkloadGroupMetadata after) {
            this.dataStreamDiff = DiffableUtils.diff(before.workloadGroups, after.workloadGroups, DiffableUtils.getStringKeySerializer());
        }

        WorkloadGroupMetadataDiff(StreamInput in) throws IOException {
            this.dataStreamDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), WorkloadGroup::new, WorkloadGroup::readDiff);
        }

        public String getWriteableName() {
            return WorkloadGroupMetadata.TYPE;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.dataStreamDiff.writeTo(out);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new WorkloadGroupMetadata(new HashMap<String, WorkloadGroup>(this.dataStreamDiff.apply(((WorkloadGroupMetadata)part).workloadGroups)));
        }
    }
}

