/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.Map;
import java.util.function.Predicate;
import org.opensearch.cluster.routing.allocation.ConstraintTypes;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;

public class Constraint
implements Predicate<ConstraintParams> {
    private boolean enable;
    private Predicate<ConstraintParams> predicate;

    public Constraint(Predicate<ConstraintParams> constraintPredicate) {
        this.predicate = constraintPredicate;
    }

    @Override
    public boolean test(ConstraintParams constraintParams) {
        return this.enable && this.predicate.test(constraintParams);
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    static class ConstraintParams {
        private ShardsBalancer balancer;
        private BalancedShardsAllocator.ModelNode node;
        private String index;
        private long PrimaryConstraintThreshold;

        ConstraintParams(ShardsBalancer balancer, BalancedShardsAllocator.ModelNode node, String index, long primaryConstraintThreshold) {
            this.balancer = balancer;
            this.node = node;
            this.index = index;
            this.PrimaryConstraintThreshold = primaryConstraintThreshold;
        }

        public ShardsBalancer getBalancer() {
            return this.balancer;
        }

        public BalancedShardsAllocator.ModelNode getNode() {
            return this.node;
        }

        public String getIndex() {
            return this.index;
        }

        public long weight(Map<String, Constraint> constraints) {
            long totalConstraintWeight = 0L;
            for (Map.Entry<String, Constraint> entry : constraints.entrySet()) {
                String key = entry.getKey();
                Constraint constraint = entry.getValue();
                if (!constraint.test(this)) continue;
                double weight = ConstraintTypes.predicateKeyToWeightMap(key, this.PrimaryConstraintThreshold);
                totalConstraintWeight = (long)((double)totalConstraintWeight + weight);
            }
            return totalConstraintWeight;
        }
    }
}

