/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.io.IOException;
import java.util.Arrays;
import org.opensearch.OpenSearchException;
import org.opensearch.common.cache.serializer.Serializer;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.indices.IndicesRequestCache;

public class IRCKeyWriteableSerializer
implements Serializer<IndicesRequestCache.Key, byte[]> {
    @Override
    public byte[] serialize(IndicesRequestCache.Key object) {
        if (object == null) {
            return null;
        }
        try {
            BytesStreamOutput os = new BytesStreamOutput();
            object.writeTo((StreamOutput)os);
            return BytesReference.toBytes((BytesReference)os.bytes());
        }
        catch (IOException e) {
            throw new OpenSearchException("Unable to serialize IndicesRequestCache.Key", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public IndicesRequestCache.Key deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            BytesStreamInput is = new BytesStreamInput(bytes, 0, bytes.length);
            return new IndicesRequestCache.Key((StreamInput)is);
        }
        catch (IOException e) {
            throw new OpenSearchException("Unable to deserialize byte[] to IndicesRequestCache.Key", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean equals(IndicesRequestCache.Key object, byte[] bytes) {
        if (bytes.length < 5000) {
            return Arrays.equals(this.serialize(object), bytes);
        }
        return object.equals(this.deserialize(bytes));
    }
}

