/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol.controllers;

import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.opensearch.node.NodeResourceUsageStats;
import org.opensearch.node.ResourceUsageCollectorService;
import org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.opensearch.ratelimitting.admissioncontrol.settings.IoBasedAdmissionControllerSettings;

public class IoBasedAdmissionController
extends AdmissionController {
    public static final String IO_BASED_ADMISSION_CONTROLLER = "global_io_usage";
    private static final Logger LOGGER = LogManager.getLogger(IoBasedAdmissionController.class);
    public IoBasedAdmissionControllerSettings settings;

    public IoBasedAdmissionController(String admissionControllerName, ResourceUsageCollectorService resourceUsageCollectorService, ClusterService clusterService, Settings settings) {
        super(admissionControllerName, resourceUsageCollectorService, clusterService);
        this.settings = new IoBasedAdmissionControllerSettings(clusterService.getClusterSettings(), settings);
    }

    @Override
    public void apply(String action, AdmissionControlActionType admissionControlActionType) {
        if (this.isEnabledForTransportLayer(this.settings.getTransportLayerAdmissionControllerMode())) {
            this.applyForTransportLayer(action, admissionControlActionType);
        }
    }

    private void applyForTransportLayer(String actionName, AdmissionControlActionType admissionControlActionType) {
        if (this.isLimitsBreached(actionName, admissionControlActionType)) {
            this.addRejectionCount(admissionControlActionType.getType(), 1L);
            if (this.isAdmissionControllerEnforced(this.settings.getTransportLayerAdmissionControllerMode()).booleanValue()) {
                throw new OpenSearchRejectedExecutionException(String.format(Locale.ROOT, "IO usage admission controller rejected the request for action [%s] as IO limit reached for action-type [%s]", actionName, admissionControlActionType.name()));
            }
        }
    }

    private boolean isLimitsBreached(String actionName, AdmissionControlActionType admissionControlActionType) {
        if (this.clusterService.state() != null && this.clusterService.state().nodes() != null) {
            double ioUsage;
            long ioUsageThreshold = this.getIoRejectionThreshold(admissionControlActionType);
            Optional<NodeResourceUsageStats> nodePerformanceStatistics = this.resourceUsageCollectorService.getNodeStatistics(this.clusterService.state().nodes().getLocalNodeId());
            if (nodePerformanceStatistics.isPresent() && (ioUsage = nodePerformanceStatistics.get().getIoUsageStats().getIoUtilisationPercent()) >= (double)ioUsageThreshold) {
                LOGGER.warn("IoBasedAdmissionController limit reached as the current IO usage [{}] exceeds the allowed limit [{}] for transport action [{}] in admissionControlMode [{}]", (Object)ioUsage, (Object)ioUsageThreshold, (Object)actionName, (Object)this.settings.getTransportLayerAdmissionControllerMode());
                return true;
            }
        }
        return false;
    }

    private long getIoRejectionThreshold(AdmissionControlActionType admissionControlActionType) {
        switch (admissionControlActionType) {
            case SEARCH: {
                return this.settings.getSearchIOUsageLimit();
            }
            case INDEXING: {
                return this.settings.getIndexingIOUsageLimit();
            }
            case CLUSTER_ADMIN: {
                return this.settings.getClusterAdminIOUsageLimit();
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Admission control not Supported for AdmissionControlActionType: %s", admissionControlActionType.getType()));
    }
}

