/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest;

import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class BytesRestResponse
extends RestResponse {
    public static final String TEXT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final String STATUS = "status";
    private static final Logger SUPPRESSED_ERROR_LOGGER = LogManager.getLogger((String)"rest.suppressed");
    private final RestStatus status;
    private final BytesReference content;
    private final String contentType;

    public BytesRestResponse(RestStatus status, XContentBuilder builder) {
        this(status, builder.contentType().mediaType(), BytesReference.bytes((XContentBuilder)builder));
    }

    public BytesRestResponse(RestStatus status, String content) {
        this(status, TEXT_CONTENT_TYPE, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, String content) {
        this(status, contentType, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, byte[] content) {
        this(status, contentType, (BytesReference)new BytesArray(content));
    }

    public BytesRestResponse(RestStatus status, String contentType, BytesReference content) {
        this.status = status;
        this.content = content;
        this.contentType = contentType;
    }

    public BytesRestResponse(RestChannel channel, Exception e) throws IOException {
        this(channel, ExceptionsHelper.status((Throwable)e), e);
    }

    public BytesRestResponse(RestChannel channel, RestStatus status, Exception e) throws IOException {
        ToXContent.Params params = this.paramsFromRequest(channel.request());
        if (params.paramAsBoolean("rest.exception.stacktrace.skip", true) && e != null) {
            Supplier messageSupplier = () -> new ParameterizedMessage("path: {}, params: {}", (Object)channel.request().rawPath(), channel.request().params());
            if (status.getStatus() < 500) {
                SUPPRESSED_ERROR_LOGGER.debug(messageSupplier, (Throwable)e);
            } else {
                SUPPRESSED_ERROR_LOGGER.warn(messageSupplier, (Throwable)e);
            }
        }
        this.status = status;
        try (XContentBuilder builder = channel.newErrorBuilder();){
            this.build(builder, params, status, channel.detailedErrorsEnabled(), e);
            this.content = BytesReference.bytes((XContentBuilder)builder);
            this.contentType = builder.contentType().mediaType();
        }
        if (e instanceof OpenSearchException) {
            this.copyHeaders((OpenSearchException)((Object)e));
        }
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    private ToXContent.Params paramsFromRequest(RestRequest restRequest) {
        RestRequest params = restRequest;
        if (params.paramAsBoolean("error_trace", false) && !this.skipStackTrace()) {
            params = new ToXContent.DelegatingMapParams(Collections.singletonMap("rest.exception.stacktrace.skip", "false"), (ToXContent.Params)params);
        }
        return params;
    }

    protected boolean skipStackTrace() {
        return false;
    }

    private void build(XContentBuilder builder, ToXContent.Params params, RestStatus status, boolean detailedErrorsEnabled, Exception e) throws IOException {
        builder.startObject();
        OpenSearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)e, (boolean)detailedErrorsEnabled);
        builder.field(STATUS, status.getStatus());
        builder.endObject();
    }

    static BytesRestResponse createSimpleErrorResponse(RestChannel channel, RestStatus status, String errorMessage) throws IOException {
        return new BytesRestResponse(status, channel.newErrorBuilder().startObject().field("error", errorMessage).field(STATUS, status.getStatus()).endObject());
    }

    public static OpenSearchStatusException errorFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        OpenSearchException exception = null;
        RestStatus status = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }
            if (STATUS.equals(currentFieldName)) {
                if (token == XContentParser.Token.FIELD_NAME) continue;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                status = RestStatus.fromCode((int)parser.intValue());
                continue;
            }
            exception = OpenSearchException.failureFromXContent((XContentParser)parser);
        }
        if (exception == null) {
            throw new IllegalStateException("Failed to parse opensearch status exception: no exception was found");
        }
        OpenSearchStatusException result = new OpenSearchStatusException(exception.getMessage(), status, exception.getCause(), new Object[0]);
        for (String header : exception.getHeaderKeys()) {
            result.addHeader(header, exception.getHeader(header));
        }
        for (String metadata : exception.getMetadataKeys()) {
            result.addMetadata(metadata, exception.getMetadata(metadata));
        }
        return result;
    }
}

