/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.opensearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.opensearch.search.aggregations.support.AggregationPath;

@PublicApi(since="1.0.0")
public final class InternalAggregations
extends Aggregations
implements Writeable {
    public static final InternalAggregations EMPTY = new InternalAggregations(Collections.emptyList());
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.isMapped() == agg2.isMapped()) {
            return 0;
        }
        if (agg1.isMapped() && !agg2.isMapped()) {
            return -1;
        }
        return 1;
    };

    public InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
    }

    public static InternalAggregations from(List<InternalAggregation> aggregations) {
        if (aggregations.isEmpty()) {
            return EMPTY;
        }
        return new InternalAggregations(aggregations);
    }

    public static InternalAggregations readFrom(StreamInput in) throws IOException {
        InternalAggregations res = InternalAggregations.from(in.readList(stream -> (InternalAggregation)in.readNamedWriteable(InternalAggregation.class)));
        return res;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.getInternalAggregations());
    }

    public List<InternalAggregation> copyResults() {
        return new ArrayList<InternalAggregation>(this.getInternalAggregations());
    }

    private List<InternalAggregation> getInternalAggregations() {
        return this.aggregations;
    }

    public double sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        InternalAggregation aggregation = (InternalAggregation)this.get(head.name);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find aggregation named [" + head.name + "]");
        }
        if (tail.hasNext()) {
            return aggregation.sortValue(tail.next(), tail);
        }
        return aggregation.sortValue(head.key);
    }

    public static InternalAggregations topLevelReduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        InternalAggregations reduced = InternalAggregations.reduce(aggregationsList, context);
        if (reduced == null) {
            return null;
        }
        if (context.isFinalReduce()) {
            List<InternalAggregation> reducedInternalAggs = reduced.getInternalAggregations();
            reducedInternalAggs = reducedInternalAggs.stream().map(agg -> agg.reducePipelines((InternalAggregation)agg, context, context.pipelineTreeRoot().subTree(agg.getName()))).collect(Collectors.toList());
            for (PipelineAggregator pipelineAggregator : context.pipelineTreeRoot().aggregators()) {
                SiblingPipelineAggregator sib = (SiblingPipelineAggregator)pipelineAggregator;
                InternalAggregation newAgg = sib.doReduce(InternalAggregations.from(reducedInternalAggs), context);
                reducedInternalAggs.add(newAgg);
            }
            return InternalAggregations.from(reducedInternalAggs);
        }
        return reduced;
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, InternalAggregation.ReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            aggregations.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            if (first.mustReduceOnSingleInternalAgg() || aggregations.size() > 1) {
                reducedAggregations.add(first.reduce(aggregations, context));
                continue;
            }
            reducedAggregations.add(first);
        }
        return new InternalAggregations((List<InternalAggregation>)reducedAggregations);
    }

    public long getSerializedSize() {
        long l;
        CountingStreamOutput out = new CountingStreamOutput();
        try {
            out.setVersion(Version.CURRENT);
            this.writeTo(out);
            l = out.size;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
        }
        out.close();
        return l;
    }

    public static InternalAggregations merge(InternalAggregations first, InternalAggregations second) {
        List<InternalAggregation> fromFirst = first.getInternalAggregations();
        List<InternalAggregation> fromSecond = second.getInternalAggregations();
        ArrayList<InternalAggregation> mergedAggregation = new ArrayList<InternalAggregation>(fromFirst.size() + fromSecond.size());
        mergedAggregation.addAll(fromFirst);
        mergedAggregation.addAll(fromSecond);
        return new InternalAggregations((List<InternalAggregation>)mergedAggregation);
    }

    private static class CountingStreamOutput
    extends StreamOutput {
        long size = 0L;

        private CountingStreamOutput() {
        }

        public void writeByte(byte b) throws IOException {
            ++this.size;
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.size += (long)length;
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void reset() throws IOException {
            this.size = 0L;
        }

        public long length() {
            return this.size;
        }
    }
}

