/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.opensearch.common.TriConsumer;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.script.Script;

public abstract class BaseMultiValuesSourceFieldConfig
implements Writeable,
ToXContentObject {
    private final String fieldName;
    private final Object missing;
    private final Script script;
    private final ZoneId timeZone;
    static TriConsumer<ObjectParser<? extends Builder<? extends BaseMultiValuesSourceFieldConfig, ? extends Builder<?, ?>>, Void>, Boolean, Boolean> PARSER = (parser, scriptable, timezoneAware) -> {
        parser.declareString(Builder::setFieldName, ParseField.CommonFields.FIELD);
        parser.declareField(Builder::setMissing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        if (scriptable.booleanValue()) {
            parser.declareField(Builder::setScript, (p, context) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        }
        if (timezoneAware.booleanValue()) {
            parser.declareField(Builder::setTimeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
    };

    public BaseMultiValuesSourceFieldConfig(String fieldName, Object missing, Script script, ZoneId timeZone) {
        this.fieldName = fieldName;
        this.missing = missing;
        this.script = script;
        this.timeZone = timeZone;
    }

    public BaseMultiValuesSourceFieldConfig(StreamInput in) throws IOException {
        this.fieldName = in.readOptionalString();
        this.missing = in.readGenericValue();
        this.script = (Script)in.readOptionalWriteable(Script::new);
        this.timeZone = in.readOptionalZoneId();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.fieldName);
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable((Writeable)this.script);
        out.writeOptionalZoneId(this.timeZone);
        this.doWriteTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.missing != null) {
            builder.field(ParseField.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.script != null) {
            builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), (ToXContent)this.script);
        }
        if (this.fieldName != null) {
            builder.field(ParseField.CommonFields.FIELD.getPreferredName(), this.fieldName);
        }
        if (this.timeZone != null) {
            builder.field(ParseField.CommonFields.TIME_ZONE.getPreferredName(), this.timeZone.getId());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public Object getMissing() {
        return this.missing;
    }

    public Script getScript() {
        return this.script;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseMultiValuesSourceFieldConfig that = (BaseMultiValuesSourceFieldConfig)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.missing, that.missing) && Objects.equals(this.script, that.script) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.missing, this.script, this.timeZone);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    abstract void doWriteTo(StreamOutput var1) throws IOException;

    public static abstract class Builder<C extends BaseMultiValuesSourceFieldConfig, B extends Builder<C, B>> {
        String fieldName;
        Object missing = null;
        Script script = null;
        ZoneId timeZone = null;

        public String getFieldName() {
            return this.fieldName;
        }

        public B setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return (B)this;
        }

        public Object getMissing() {
            return this.missing;
        }

        public B setMissing(Object missing) {
            this.missing = missing;
            return (B)this;
        }

        public Script getScript() {
            return this.script;
        }

        public B setScript(Script script) {
            this.script = script;
            return (B)this;
        }

        public ZoneId getTimeZone() {
            return this.timeZone;
        }

        public B setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return (B)this;
        }

        public abstract C build();
    }
}

