/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.ProcessorExecutionDetail;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class TrackingSearchRequestProcessorWrapper
implements SearchRequestProcessor {
    private final SearchRequestProcessor wrappedProcessor;

    public TrackingSearchRequestProcessorWrapper(SearchRequestProcessor wrappedProcessor) {
        this.wrappedProcessor = wrappedProcessor;
    }

    @Override
    public String getType() {
        return this.wrappedProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.wrappedProcessor.getTag();
    }

    @Override
    public String getDescription() {
        return this.wrappedProcessor.getDescription();
    }

    @Override
    public boolean isIgnoreFailure() {
        return this.wrappedProcessor.isIgnoreFailure();
    }

    @Override
    public SearchRequest processRequest(SearchRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchRequest processRequest(SearchRequest request, PipelineProcessingContext requestContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processRequestAsync(SearchRequest request, PipelineProcessingContext requestContext, ActionListener<SearchRequest> requestListener) {
        ProcessorExecutionDetail detail = new ProcessorExecutionDetail(this.getType(), this.getTag());
        long start = System.nanoTime();
        detail.addInput(request.source().toString());
        this.wrappedProcessor.processRequestAsync(request, requestContext, (ActionListener<SearchRequest>)ActionListener.wrap(result -> {
            detail.addOutput(result.source().toString());
            long took = System.nanoTime() - start;
            detail.addTook(took);
            requestContext.addProcessorExecutionDetail(detail);
            requestListener.onResponse(result);
        }, e -> {
            detail.markProcessorAsFailed(ProcessorExecutionDetail.ProcessorStatus.FAIL, e.getMessage());
            requestContext.addProcessorExecutionDetail(detail);
            requestListener.onFailure(e);
        }));
    }
}

