/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter;

import java.io.IOException;
import java.util.Iterator;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNodeType;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeNodeCollector;
import org.opensearch.search.startree.filter.DimensionFilter;

@ExperimentalApi
public class MatchAllFilter
implements DimensionFilter {
    public final String dimensionName;
    public final String subDimensionName;

    public MatchAllFilter(String dimensionName) {
        this.dimensionName = dimensionName;
        this.subDimensionName = null;
    }

    public MatchAllFilter(String dimensionName, String subDimensionName) {
        this.dimensionName = dimensionName;
        this.subDimensionName = subDimensionName;
    }

    @Override
    public void initialiseForSegment(StarTreeValues starTreeValues, SearchContext searchContext) throws IOException {
    }

    @Override
    public void matchStarTreeNodes(StarTreeNode parentNode, StarTreeValues starTreeValues, StarTreeNodeCollector collector) throws IOException {
        if (parentNode != null) {
            Iterator<? extends StarTreeNode> it = parentNode.getChildrenIterator();
            while (it.hasNext()) {
                StarTreeNode starTreeNode = it.next();
                if (starTreeNode.getStarTreeNodeType() != StarTreeNodeType.DEFAULT.getValue() && starTreeNode.getStarTreeNodeType() != StarTreeNodeType.NULL.getValue()) continue;
                collector.collectStarTreeNode(starTreeNode);
            }
        }
    }

    @Override
    public boolean matchDimValue(long ordinal, StarTreeValues starTreeValues) {
        return true;
    }

    @Override
    public String getDimensionName() {
        return this.dimensionName;
    }

    @Override
    public String getSubDimensionName() {
        return this.subDimensionName;
    }
}

