/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskAwareRequest;
import org.opensearch.tasks.TaskManager;
import org.opensearch.transport.BaseTcpTransportChannel;
import org.opensearch.transport.TaskTransportChannel;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;

@PublicApi(since="1.0.0")
public final class RequestHandlerRegistry<Request extends TransportRequest> {
    private final String action;
    private final TransportRequestHandler<Request> handler;
    private final boolean forceExecution;
    private final boolean canTripCircuitBreaker;
    private final String executor;
    private final TaskManager taskManager;
    private final Writeable.Reader<Request> requestReader;

    public RequestHandlerRegistry(String action, Writeable.Reader<Request> requestReader, TaskManager taskManager, TransportRequestHandler<Request> handler, String executor, boolean forceExecution, boolean canTripCircuitBreaker) {
        this.action = action;
        this.requestReader = requestReader;
        this.handler = handler;
        this.forceExecution = forceExecution;
        this.canTripCircuitBreaker = canTripCircuitBreaker;
        this.executor = executor;
        this.taskManager = taskManager;
    }

    public String getAction() {
        return this.action;
    }

    public Request newRequest(StreamInput in) throws IOException {
        return (Request)((TransportRequest)this.requestReader.read(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessageReceived(Request request, TransportChannel channel) throws Exception {
        Task task = this.taskManager.register(channel.getChannelType(), this.action, (TaskAwareRequest)request);
        ThreadContext.StoredContext contextToRestore = this.taskManager.taskExecutionStarted(task);
        Releasable unregisterTask = () -> this.taskManager.unregister(task);
        try {
            if (channel instanceof BaseTcpTransportChannel && task instanceof CancellableTask) {
                if (request instanceof ShardSearchRequest) {
                    ((ShardSearchRequest)request).setInboundNetworkTime(Math.max(0L, System.currentTimeMillis() - ((ShardSearchRequest)request).getInboundNetworkTime()));
                }
                TcpChannel tcpChannel = ((BaseTcpTransportChannel)channel).getChannel();
                Releasable stopTracking = this.taskManager.startTrackingCancellableChannelTask(tcpChannel, (CancellableTask)task);
                unregisterTask = Releasables.wrap((Releasable[])new Releasable[]{unregisterTask, stopTracking});
            }
            TaskTransportChannel taskTransportChannel = new TaskTransportChannel(channel, unregisterTask);
            this.handler.messageReceived(request, taskTransportChannel, task);
            unregisterTask = null;
        }
        finally {
            Releasables.close((Releasable)unregisterTask);
            contextToRestore.restore();
        }
    }

    public boolean isForceExecution() {
        return this.forceExecution;
    }

    public boolean canTripCircuitBreaker() {
        return this.canTripCircuitBreaker;
    }

    public String getExecutor() {
        return this.executor;
    }

    public TransportRequestHandler<Request> getHandler() {
        return this.handler;
    }

    public String toString() {
        return this.handler.toString();
    }

    public static <R extends TransportRequest> RequestHandlerRegistry<R> replaceHandler(RequestHandlerRegistry<R> registry, TransportRequestHandler<R> handler) {
        return new RequestHandlerRegistry(registry.action, registry.requestReader, registry.taskManager, handler, registry.executor, registry.forceExecution, registry.canTripCircuitBreaker);
    }
}

