/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.tracker;

import java.util.List;
import org.opensearch.core.tasks.resourcetracker.ResourceStats;
import org.opensearch.wlm.WorkloadGroupTask;
import org.opensearch.wlm.tracker.ResourceUsageCalculator;

public class CpuUsageCalculator
extends ResourceUsageCalculator {
    public static final int PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    public static final CpuUsageCalculator INSTANCE = new CpuUsageCalculator();

    private CpuUsageCalculator() {
    }

    @Override
    public double calculateResourceUsage(List<WorkloadGroupTask> tasks) {
        double usage = tasks.stream().mapToDouble(this::calculateTaskResourceUsage).sum();
        return usage /= (double)PROCESSOR_COUNT;
    }

    @Override
    public double calculateTaskResourceUsage(WorkloadGroupTask task) {
        return 1.0f * (float)task.getTotalResourceUtilization(ResourceStats.CPU) / (float)task.getElapsedTime();
    }
}

