// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { decorateProperties, getEncryptionMaterials, decryptMaterials, cacheEntryHasExceededLimits, buildCryptographicMaterialsCacheKeyHelpers, } from '@aws-crypto/cache-material';
import { NodeDefaultCryptographicMaterialsManager, KeyringNode, } from '@aws-crypto/material-management-node';
import { sha512 } from './sha512';
import { randomBytes } from 'crypto';
const fromUtf8 = (input) => Buffer.from(input, 'utf8');
const toUtf8 = (input) => Buffer.from(input).toString('utf8');
const cacheKeyHelpers = buildCryptographicMaterialsCacheKeyHelpers(fromUtf8, toUtf8, sha512);
export class NodeCachingMaterialsManager {
    constructor(input) {
        const backingMaterialsManager = input.backingMaterials instanceof KeyringNode
            ? new NodeDefaultCryptographicMaterialsManager(input.backingMaterials)
            : input.backingMaterials;
        /* Precondition: A partition value must exist for NodeCachingMaterialsManager.
         * The maximum hash function at this time is 512.
         * So I create 64 bytes of random data.
         */
        const { partition = randomBytes(64).toString('base64') } = input;
        decorateProperties(this, {
            ...input,
            backingMaterialsManager,
            partition,
        });
    }
    getEncryptionMaterials = getEncryptionMaterials(cacheKeyHelpers);
    decryptMaterials = decryptMaterials(cacheKeyHelpers);
    _cacheEntryHasExceededLimits = cacheEntryHasExceededLimits();
}
//= aws-encryption-sdk-specification/framework/aws-kms/aws-kms-hierarchical-keyring.md#appendix-a-cache-entry-identifier-formulas
//# When accessing the underlying cryptographic materials cache,
//# the hierarchical keyring MUST use the formulas specified in this appendix
//# in order to compute the [cache entry identifier](../cryptographic-materials-cache.md#cache-identifier).
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGluZ19tYXRlcmlhbHNfbWFuYWdlcl9ub2RlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2NhY2hpbmdfbWF0ZXJpYWxzX21hbmFnZXJfbm9kZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxvRUFBb0U7QUFDcEUsc0NBQXNDO0FBRXRDLE9BQU8sRUFFTCxrQkFBa0IsRUFDbEIsc0JBQXNCLEVBQ3RCLGdCQUFnQixFQUNoQiwyQkFBMkIsRUFDM0IsMENBQTBDLEdBRzNDLE1BQU0sNEJBQTRCLENBQUE7QUFDbkMsT0FBTyxFQUVMLHdDQUF3QyxFQUV4QyxXQUFXLEdBR1osTUFBTSxzQ0FBc0MsQ0FBQTtBQUM3QyxPQUFPLEVBQUUsTUFBTSxFQUFFLE1BQU0sVUFBVSxDQUFBO0FBQ2pDLE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxRQUFRLENBQUE7QUFFcEMsTUFBTSxRQUFRLEdBQUcsQ0FBQyxLQUFhLEVBQUUsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFBO0FBQzlELE1BQU0sTUFBTSxHQUFHLENBQUMsS0FBaUIsRUFBRSxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUE7QUFFekUsTUFBTSxlQUFlLEdBQUcsMENBQTBDLENBQ2hFLFFBQVEsRUFDUixNQUFNLEVBQ04sTUFBTSxDQUNQLENBQUE7QUFFRCxNQUFNLE9BQU8sMkJBQTJCO0lBVXRDLFlBQVksS0FBdUQ7UUFDakUsTUFBTSx1QkFBdUIsR0FDM0IsS0FBSyxDQUFDLGdCQUFnQixZQUFZLFdBQVc7WUFDM0MsQ0FBQyxDQUFDLElBQUksd0NBQXdDLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1lBQ3RFLENBQUMsQ0FBRSxLQUFLLENBQUMsZ0JBQTZELENBQUE7UUFFMUU7OztXQUdHO1FBQ0gsTUFBTSxFQUFFLFNBQVMsR0FBRyxXQUFXLENBQUMsRUFBRSxDQUFDLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFBO1FBRWhFLGtCQUFrQixDQUFDLElBQUksRUFBRTtZQUN2QixHQUFHLEtBQUs7WUFDUix1QkFBdUI7WUFDdkIsU0FBUztTQUNWLENBQUMsQ0FBQTtJQUNKLENBQUM7SUFFRCxzQkFBc0IsR0FDcEIsc0JBQXNCLENBQXFCLGVBQWUsQ0FBQyxDQUFBO0lBQzdELGdCQUFnQixHQUNkLGdCQUFnQixDQUFxQixlQUFlLENBQUMsQ0FBQTtJQUN2RCw0QkFBNEIsR0FDMUIsMkJBQTJCLEVBQXNCLENBQUE7Q0FDcEQ7QUFDRCxpSUFBaUk7QUFDakksZ0VBQWdFO0FBQ2hFLDZFQUE2RTtBQUM3RSwyR0FBMkcifQ==