"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.linkTextLayout = void 0;
var color_calcs_1 = require("../../../../common/color_calcs");
var constants_1 = require("../../../../common/constants");
var geometry_1 = require("../../../../common/geometry");
var text_utils_1 = require("../../../../common/text_utils");
function linkTextLayout(rectWidth, rectHeight, measure, config, nodesWithoutRoom, currentY, anchorRadius, rawTextGetter, valueGetter, valueFormatter, maxTextLength, diskCenter, containerBackgroundColor) {
    var linkLabel = config.linkLabel, sectorLineStroke = config.sectorLineStroke;
    var maxDepth = nodesWithoutRoom.reduce(function (p, n) { return Math.max(p, n.depth); }, 0);
    var yRelativeIncrement = Math.sin(linkLabel.stemAngle) * linkLabel.minimumStemLength;
    var rowPitch = linkLabel.fontSize + linkLabel.spacing;
    var _a = color_calcs_1.getOnPaperColorSet(linkLabel.textColor, sectorLineStroke, containerBackgroundColor), contrastTextColor = _a.contrastTextColor, strokeColor = _a.strokeColor;
    var labelFontSpec = __assign(__assign({}, linkLabel), { textColor: contrastTextColor });
    var valueFontSpec = __assign(__assign(__assign({}, linkLabel), linkLabel.valueFont), { textColor: contrastTextColor });
    var linkLabels = nodesWithoutRoom
        .filter(function (n) { return n.depth === maxDepth; })
        .sort(function (n1, n2) { return Math.abs(n2.x0 - n2.x1) - Math.abs(n1.x0 - n1.x1); })
        .slice(0, linkLabel.maxCount)
        .sort(linkLabelCompare)
        .map(nodeToLinkLabel({
        linkLabel: linkLabel,
        anchorRadius: anchorRadius,
        currentY: currentY,
        rowPitch: rowPitch,
        yRelativeIncrement: yRelativeIncrement,
        rawTextGetter: rawTextGetter,
        maxTextLength: maxTextLength,
        valueFormatter: valueFormatter,
        valueGetter: valueGetter,
        measure: measure,
        rectWidth: rectWidth,
        rectHeight: rectHeight,
        diskCenter: diskCenter,
    }))
        .filter(function (_a) {
        var text = _a.text;
        return text !== '';
    });
    return { linkLabels: linkLabels, valueFontSpec: valueFontSpec, labelFontSpec: labelFontSpec, strokeColor: strokeColor };
}
exports.linkTextLayout = linkTextLayout;
function linkLabelCompare(n1, n2) {
    var mid1 = geometry_1.meanAngle(n1.x0, n1.x1);
    var mid2 = geometry_1.meanAngle(n2.x0, n2.x1);
    var dist1 = Math.min(Math.abs(mid1 - constants_1.TAU / 4), Math.abs(mid1 - (3 * constants_1.TAU) / 4));
    var dist2 = Math.min(Math.abs(mid2 - constants_1.TAU / 4), Math.abs(mid2 - (3 * constants_1.TAU) / 4));
    return dist1 - dist2;
}
function nodeToLinkLabel(_a) {
    var linkLabel = _a.linkLabel, anchorRadius = _a.anchorRadius, currentY = _a.currentY, rowPitch = _a.rowPitch, yRelativeIncrement = _a.yRelativeIncrement, rawTextGetter = _a.rawTextGetter, maxTextLength = _a.maxTextLength, valueFormatter = _a.valueFormatter, valueGetter = _a.valueGetter, measure = _a.measure, rectWidth = _a.rectWidth, rectHeight = _a.rectHeight, diskCenter = _a.diskCenter;
    var labelFont = linkLabel;
    var valueFont = __assign(__assign({}, labelFont), linkLabel.valueFont);
    return function nodeToLinkLabelMap(node) {
        var midAngle = geometry_1.trueBearingToStandardPositionAngle((node.x0 + node.x1) / 2);
        var north = midAngle < constants_1.TAU / 2 ? 1 : -1;
        var rightSide = constants_1.TAU / 4 < midAngle && midAngle < (3 * constants_1.TAU) / 4 ? 0 : 1;
        var west = rightSide ? 1 : -1;
        var cos = Math.cos(midAngle);
        var sin = Math.sin(midAngle);
        var x0 = cos * anchorRadius;
        var y0 = sin * anchorRadius;
        var x = cos * (anchorRadius + linkLabel.radiusPadding);
        var y = sin * (anchorRadius + linkLabel.radiusPadding);
        var stemFromX = x;
        var stemFromY = y;
        var poolIndex = rightSide + (1 - north);
        var relativeY = north * y;
        var yOffset = Math.max(currentY[poolIndex] + rowPitch, relativeY + yRelativeIncrement, rowPitch / 2);
        currentY[poolIndex] = yOffset;
        var cy = north * yOffset;
        var stemToX = x + north * west * cy - west * relativeY;
        var stemToY = cy;
        var translateX = stemToX + west * (linkLabel.horizontalStemLength + linkLabel.gap);
        var translate = [translateX, stemToY];
        var linkLabels = [
            [x0, y0],
            [stemFromX, stemFromY],
            [stemToX, stemToY],
            [stemToX + west * linkLabel.horizontalStemLength, stemToY],
        ];
        var valueText = valueFormatter(valueGetter(node));
        var valueWidth = text_utils_1.measureOneBoxWidth(measure, linkLabel.fontSize, __assign(__assign({}, valueFont), { text: valueText }));
        var widthAdjustment = valueWidth + 2 * linkLabel.fontSize;
        var labelText = text_utils_1.cutToLength(rawTextGetter(node), maxTextLength);
        var allottedLabelWidth = Math.max(0, rightSide ? rectWidth - diskCenter.x - translateX - widthAdjustment : diskCenter.x + translateX - widthAdjustment);
        var _a = linkLabel.fontSize / 2 <= cy + diskCenter.y && cy + diskCenter.y <= rectHeight - linkLabel.fontSize / 2
            ? text_utils_1.fitText(measure, labelText, allottedLabelWidth, linkLabel.fontSize, labelFont)
            : { text: '', width: 0, verticalOffset: 0 }, text = _a.text, width = _a.width, verticalOffset = _a.verticalOffset;
        return {
            linkLabels: linkLabels,
            translate: translate,
            text: text,
            valueText: valueText,
            width: width,
            valueWidth: valueWidth,
            verticalOffset: verticalOffset,
            textAlign: rightSide ? 'left' : 'right',
        };
    };
}
//# sourceMappingURL=link_text_layout.js.map