"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getScaleConfigsFromSpecs = exports.getScaleConfigsFromSpecsSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var x_domain_1 = require("../../domains/x_domain");
var y_domain_1 = require("../../domains/y_domain");
var get_api_scales_1 = require("../../scales/get_api_scales");
var scale_defaults_1 = require("../../scales/scale_defaults");
var axis_type_utils_1 = require("../../utils/axis_type_utils");
var group_data_series_1 = require("../../utils/group_data_series");
var common_1 = require("../utils/common");
var spec_1 = require("../utils/spec");
var get_specs_1 = require("./get_specs");
var merge_y_custom_domains_1 = require("./merge_y_custom_domains");
exports.getScaleConfigsFromSpecsSelector = create_selector_1.createCustomCachedSelector([get_specs_1.getAxisSpecsSelector, get_specs_1.getSeriesSpecsSelector, get_settings_specs_1.getSettingsSpecSelector], getScaleConfigsFromSpecs);
function getScaleConfigsFromSpecs(axisSpecs, seriesSpecs, settingsSpec) {
    var isHorizontalChart = common_1.isHorizontalRotation(settingsSpec.rotation);
    var xAxes = axisSpecs.filter(function (d) { return isHorizontalChart === axis_type_utils_1.isHorizontalAxis(d.position); });
    var xTicks = xAxes.reduce(function (acc, _a) {
        var _b = _a.ticks, ticks = _b === void 0 ? scale_defaults_1.X_SCALE_DEFAULT.desiredTickCount : _b;
        return Math.max(acc, ticks);
    }, scale_defaults_1.X_SCALE_DEFAULT.desiredTickCount);
    var xScaleConfig = x_domain_1.convertXScaleTypes(seriesSpecs);
    var x = __assign(__assign({ customDomain: settingsSpec.xDomain }, xScaleConfig), { desiredTickCount: xTicks });
    var scaleConfigsByGroupId = group_data_series_1.groupBy(seriesSpecs, spec_1.getSpecDomainGroupId, true).reduce(function (acc, series) {
        var yScaleTypes = series.map(function (_a) {
            var yScaleType = _a.yScaleType, yNice = _a.yNice;
            return ({
                nice: get_api_scales_1.getYNiceFromSpec(yNice),
                type: get_api_scales_1.getYScaleTypeFromSpec(yScaleType),
            });
        });
        var groupId = spec_1.getSpecDomainGroupId(series[0]);
        acc[groupId] = y_domain_1.coerceYScaleTypes(yScaleTypes);
        return acc;
    }, {});
    var customDomainByGroupId = merge_y_custom_domains_1.mergeYCustomDomainsByGroupId(axisSpecs, settingsSpec.rotation);
    var yAxes = axisSpecs.filter(function (d) { return isHorizontalChart === axis_type_utils_1.isVerticalAxis(d.position); });
    var y = Object.keys(scaleConfigsByGroupId).reduce(function (acc, groupId) {
        var _a;
        var axis = yAxes.find(function (yAxis) { return yAxis.groupId === groupId; });
        var desiredTickCount = (_a = axis === null || axis === void 0 ? void 0 : axis.ticks) !== null && _a !== void 0 ? _a : scale_defaults_1.Y_SCALE_DEFAULT.desiredTickCount;
        var scaleConfig = scaleConfigsByGroupId[groupId];
        var customDomain = customDomainByGroupId.get(groupId);
        if (!acc[groupId]) {
            acc[groupId] = __assign(__assign({ customDomain: customDomain }, scaleConfig), { desiredTickCount: desiredTickCount });
        }
        acc[groupId].desiredTickCount = Math.max(acc[groupId].desiredTickCount, desiredTickCount);
        return acc;
    }, {});
    return { x: x, y: y };
}
exports.getScaleConfigsFromSpecs = getScaleConfigsFromSpecs;
//# sourceMappingURL=get_api_scale_configs.js.map