"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "_EuiSplitPanelInner", {
  enumerable: true,
  get: function get() {
    return _split_panel._EuiSplitPanelInner;
  }
});
Object.defineProperty(exports, "_EuiSplitPanelOuter", {
  enumerable: true,
  get: function get() {
    return _split_panel._EuiSplitPanelOuter;
  }
});
Object.defineProperty(exports, "EuiSplitPanel", {
  enumerable: true,
  get: function get() {
    return _split_panel.EuiSplitPanel;
  }
});
exports.OuiSplitPanel = exports._OuiSplitPanelOuter = exports._OuiSplitPanelInner = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _panel = require("../panel");
var _hooks = require("../../../services/hooks");
var _split_panel = require("../../../eui_components/panel/split_panel/split_panel");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Consumed via `OuiSplitPanel.Inner`.
 * Extends most `OuiPanelProps`.
 */
var _OuiSplitPanelInner = function _OuiSplitPanelInner(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, ["children", "className"]);
  var classes = (0, _classnames.default)('ouiSplitPanel__inner', className);
  var panelProps = {
    hasShadow: false,
    color: 'transparent',
    borderRadius: 'none',
    hasBorder: false
  };
  return /*#__PURE__*/_react.default.createElement(_panel.OuiPanel, _extends({
    element: "div",
    className: classes
  }, panelProps, rest), children);
};
exports._OuiSplitPanelInner = _OuiSplitPanelInner;
_OuiSplitPanelInner.propTypes = {
  /**
     * Padding for all four sides
     */
  paddingSize: _propTypes.default.any,
  /**
     * When true the panel will grow in height to match `OuiFlexItem`
     */
  grow: _propTypes.default.bool,
  panelRef: _propTypes.default.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
/**
 * Consumed via `OuiSplitPanel.Outer`.
 * Extends most `OuiPanelProps`.
 */
var _OuiSplitPanelOuter = function _OuiSplitPanelOuter(_ref2) {
  var children = _ref2.children,
    className = _ref2.className,
    _ref2$direction = _ref2.direction,
    direction = _ref2$direction === void 0 ? 'column' : _ref2$direction,
    _ref2$responsive = _ref2.responsive,
    responsive = _ref2$responsive === void 0 ? ['xs', 's'] : _ref2$responsive,
    rest = _objectWithoutProperties(_ref2, ["children", "className", "direction", "responsive"]);
  var isResponsive = (0, _hooks.useIsWithinBreakpoints)(responsive, !!responsive);
  var classes = (0, _classnames.default)('ouiSplitPanel', {
    'ouiSplitPanel--row': direction === 'row',
    'ouiSplitPanel-isResponsive': isResponsive
  }, className);
  return /*#__PURE__*/_react.default.createElement(_panel.OuiPanel, _extends({
    paddingSize: "none",
    grow: false,
    className: classes
  }, rest), children);
};
exports._OuiSplitPanelOuter = _OuiSplitPanelOuter;
_OuiSplitPanelOuter.propTypes = {
  /**
     * Any number of _OuiSplitPanelInner components
     */
  children: _propTypes.default.node,
  /**
     * Changes the flex-direction
     */
  direction: _propTypes.default.oneOf(["column", "row"]),
  /**
     * Stacks row display on small screens.
     * Remove completely with `false` or provide your own list of breakpoint sizes to stack on.
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.oneOf(["xs", "s", "m", "l", "xl", "xxl", "xxxl"]).isRequired).isRequired])
};
var OuiSplitPanel = {
  Outer: _OuiSplitPanelOuter,
  Inner: _OuiSplitPanelInner
};

/* OUI -> EUI Aliases: Build-Time */
/* OUI -> EUI Aliases: Build-Time */
exports.OuiSplitPanel = OuiSplitPanel;