"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lte = exports.lt = exports.gte = exports.gt = exports.exact = exports.eq = void 0;
var _date_format = require("./date_format");
var _date_value = require("./date_value");
var _predicate = require("../../../services/predicate");
var _moment = _interopRequireDefault(require("moment"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var utc = _moment.default.utc;
var resolveValueAsDate = function resolveValueAsDate(value) {
  if (_moment.default.isMoment(value)) {
    return value;
  }
  if (_moment.default.isDate(value) || (0, _predicate.isNumber)(value)) {
    return (0, _moment.default)(value);
  }
  return _date_format.dateFormat.parse(String(value));
};
var defaultEqOptions = {
  ignoreCase: true
};
var eq = function eq(fieldValue, clauseValue) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  options = _objectSpread(_objectSpread({}, defaultEqOptions), options);
  if ((0, _predicate.isNil)(fieldValue) || (0, _predicate.isNil)(clauseValue)) {
    return fieldValue === clauseValue;
  }
  if ((0, _predicate.isBoolean)(fieldValue)) {
    return clauseValue === fieldValue;
  }
  if ((0, _predicate.isArray)(fieldValue)) {
    if (fieldValue.length > 0) {
      return fieldValue.some(function (item) {
        return eq(item, clauseValue, options);
      });
    } else {
      return eq('', clauseValue, options);
    }
  }
  if ((0, _date_value.isDateValue)(clauseValue)) {
    var dateFieldValue = resolveValueAsDate(fieldValue);
    if (clauseValue.granularity) {
      return clauseValue.granularity.isSame(dateFieldValue, clauseValue.resolve());
    }
    return dateFieldValue.isSame(clauseValue.resolve());
  }
  if ((0, _predicate.isString)(fieldValue)) {
    if (options.exactMatch === true) {
      return options.ignoreCase ? fieldValue.toLowerCase() === clauseValue.toString().toLowerCase() : fieldValue === clauseValue.toString();
    } else {
      return options.ignoreCase ? fieldValue.toLowerCase().includes(clauseValue.toString().toLowerCase()) : fieldValue.includes(clauseValue.toString());
    }
  }
  if ((0, _predicate.isNumber)(fieldValue)) {
    clauseValue = Number(clauseValue);
    return fieldValue === clauseValue;
  }
  if ((0, _predicate.isDateLike)(fieldValue)) {
    var date = resolveValueAsDate(clauseValue);
    if (!date.isValid()) {
      return false;
    }
    var granularity = (0, _date_format.dateGranularity)(date);
    if (!granularity) {
      return utc(fieldValue).isSame(date);
    }
    return granularity.isSame(fieldValue, date);
  }
  return false; // unknown value type
};
exports.eq = eq;
var exact = function exact(fieldValue, clauseValue) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  return eq(fieldValue, clauseValue, _objectSpread(_objectSpread({}, options), {}, {
    exactMatch: true
  }));
};
exports.exact = exact;
var greaterThen = function greaterThen(fieldValue, clauseValue) {
  var inclusive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if ((0, _date_value.isDateValue)(clauseValue)) {
    var clauseDateValue = clauseValue.resolve();
    var fieldValueAsMomentInput = fieldValue;
    if (!clauseValue.granularity) {
      return inclusive ? utc(fieldValueAsMomentInput).isSameOrAfter(clauseDateValue) : utc(fieldValueAsMomentInput).isAfter(clauseDateValue);
    }
    if (inclusive) {
      return utc(fieldValueAsMomentInput).isSameOrAfter(clauseValue.granularity.start(clauseDateValue));
    }
    return utc(fieldValueAsMomentInput).isSameOrAfter(clauseValue.granularity.startOfNext(clauseDateValue));
  }
  if ((0, _predicate.isString)(fieldValue)) {
    var str = String(clauseValue);
    return inclusive ? fieldValue >= str : fieldValue > str;
  }
  if ((0, _predicate.isNumber)(fieldValue)) {
    var number = Number(clauseValue);
    return inclusive ? fieldValue >= number : fieldValue > number;
  }
  if ((0, _predicate.isDateLike)(fieldValue)) {
    var date = resolveValueAsDate(clauseValue);
    var granularity = (0, _date_format.dateGranularity)(date);
    if (!granularity) {
      return inclusive ? utc(fieldValue).isSameOrAfter(date) : utc(fieldValue).isAfter(date);
    }
    if (inclusive) {
      return utc(fieldValue).isSameOrAfter(granularity.start(date));
    }
    return utc(fieldValue).isSameOrAfter(granularity.startOfNext(date));
  }
  if ((0, _predicate.isArray)(fieldValue)) {
    return fieldValue.every(function (item) {
      return greaterThen(item, clauseValue, inclusive);
    });
  }
  return false; // unsupported value type
};
var gt = function gt(fieldValue, clauseValue) {
  if ((0, _predicate.isNil)(fieldValue) || (0, _predicate.isNil)(clauseValue)) {
    return false;
  }
  return greaterThen(fieldValue, clauseValue);
};
exports.gt = gt;
var gte = function gte(fieldValue, clauseValue) {
  if ((0, _predicate.isNil)(fieldValue) || (0, _predicate.isNil)(clauseValue)) {
    return fieldValue === clauseValue;
  }
  return greaterThen(fieldValue, clauseValue, true);
};
exports.gte = gte;
var lt = function lt(fieldValue, clauseValue) {
  if ((0, _predicate.isNil)(fieldValue) || (0, _predicate.isNil)(clauseValue)) {
    return false;
  }
  return !greaterThen(fieldValue, clauseValue, true);
};
exports.lt = lt;
var lte = function lte(fieldValue, clauseValue) {
  if ((0, _predicate.isNil)(fieldValue) || (0, _predicate.isNil)(clauseValue)) {
    return fieldValue === clauseValue;
  }
  return !greaterThen(fieldValue, clauseValue);
};
exports.lte = lte;