"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTitle", {
  enumerable: true,
  get: function get() {
    return _title.EuiTitle;
  }
});
exports.OuiTitle = exports.TEXT_TRANSFORM = exports.TITLE_SIZES = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _title = require("../../eui_components/title/title");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var titleSizeToClassNameMap = {
  xxxs: 'ouiTitle--xxxsmall',
  xxs: 'ouiTitle--xxsmall',
  xs: 'ouiTitle--xsmall',
  s: 'ouiTitle--small',
  m: 'ouiTitle--medium',
  l: 'ouiTitle--large'
};
var TITLE_SIZES = (0, _common.keysOf)(titleSizeToClassNameMap);
exports.TITLE_SIZES = TITLE_SIZES;
var textTransformToClassNameMap = {
  uppercase: 'ouiTitle--uppercase'
};
var TEXT_TRANSFORM = (0, _common.keysOf)(textTransformToClassNameMap);
exports.TEXT_TRANSFORM = TEXT_TRANSFORM;
var OuiTitle = function OuiTitle(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    children = _ref.children,
    className = _ref.className,
    textTransform = _ref.textTransform,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["size", "children", "className", "textTransform"]);
  var classes = (0, _classnames.default)('ouiTitle', titleSizeToClassNameMap[size], textTransform ? textTransformToClassNameMap[textTransform] : undefined, className, children.props.className);
  var props = _objectSpread({
    className: classes
  }, rest);
  return /*#__PURE__*/_react.default.cloneElement(children, props);
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiTitle = OuiTitle;
OuiTitle.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  /**
     * ReactElement to render as this component's content
     */
  children: _propTypes.default.element.isRequired,
  size: _propTypes.default.oneOf(["xxxs", "xxs", "xs", "s", "m", "l"]),
  textTransform: _propTypes.default.oneOf(["uppercase"]),
  id: _propTypes.default.string
};
/* OUI -> EUI Aliases: Build-Time */