"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeprecatedPropWarning = exports.deprecatedComponentWarning = exports.getDeprecatedMessage = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

var getDeprecatedMessage = function getDeprecatedMessage(message) {
  return "[DEPRECATED] ".concat(message);
};
exports.getDeprecatedMessage = getDeprecatedMessage;
var deprecatedComponentWarning = function deprecatedComponentWarning(_ref) {
  var newComponentName = _ref.newComponentName,
    version = _ref.version,
    getMessage = _ref.getMessage;
  return function (Component) {
    var deprecatedComponentName = Component.displayName || Component.name;
    var DeprecatedWrapper = function DeprecatedWrapper(props) {
      (0, _react.useEffect)(function () {
        var defaultMessage = version ? "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed in v").concat(version, ".") : "".concat(deprecatedComponentName, " is deprecated in favor of ").concat(newComponentName, " and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(deprecatedComponentName)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        console.warn(deprecatedMessage);
      }, []);
      return /*#__PURE__*/_react.default.createElement(Component, props);
    };
    Object.defineProperty(DeprecatedWrapper, 'name', {
      value: deprecatedComponentName
    });
    return DeprecatedWrapper;
  };
};
exports.deprecatedComponentWarning = deprecatedComponentWarning;
var useDeprecatedPropWarning = function useDeprecatedPropWarning(_ref2) {
  var props = _ref2.props,
    version = _ref2.version,
    getMessage = _ref2.getMessage;
  var warnedProps = (0, _react.useRef)(new Set()).current;
  (0, _react.useEffect)(function () {
    Object.entries(props).forEach(function (_ref3) {
      var _ref4 = (0, _slicedToArray2.default)(_ref3, 2),
        name = _ref4[0],
        value = _ref4[1];
      if (value !== undefined && !warnedProps.has(name)) {
        var defaultMessage = version ? "The `".concat(name, "` prop is deprecated and will be removed in v").concat(version, ".") : "The `".concat(name, "` prop is deprecated and will be removed.");
        var message = (getMessage === null || getMessage === void 0 ? void 0 : getMessage(name)) || defaultMessage;
        var deprecatedMessage = getDeprecatedMessage(message);
        warnedProps.add(name);
        console.warn(deprecatedMessage);
      }
    });
  }, [warnedProps, props, version, getMessage]);
};
exports.useDeprecatedPropWarning = useDeprecatedPropWarning;