"use strict";
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PPLSyntaxErrorListener = void 0;
class PPLSyntaxErrorListener {
    errors = [];
    syntaxError(recognizer, offendingSymbol, line, charPositionInLine, msg, e) {
        // Calculate end position based on offending symbol if available
        let endColumn = charPositionInLine + 1;
        if (offendingSymbol && offendingSymbol.text) {
            endColumn = charPositionInLine + offendingSymbol.text.length;
        }
        this.errors.push({
            message: msg,
            line,
            column: charPositionInLine,
            endLine: line,
            endColumn,
        });
    }
    reportAmbiguity(recognizer, dfa, startIndex, stopIndex, exact, ambigAlts, configs) {
        // Optional: handle ambiguity reporting for debugging
        // For now, we'll ignore ambiguity reports
    }
    reportAttemptingFullContext(recognizer, dfa, startIndex, stopIndex, conflictingAlts, configs) {
        // Optional: handle full context attempts for debugging
        // For now, we'll ignore these reports
    }
    reportContextSensitivity(recognizer, dfa, startIndex, stopIndex, prediction, configs) {
        // Optional: handle context sensitivity reports for debugging
        // For now, we'll ignore these reports
    }
    /**
     * Clears all collected errors
     */
    clear() {
        this.errors = [];
    }
}
exports.PPLSyntaxErrorListener = PPLSyntaxErrorListener;
//# sourceMappingURL=ppl_error_listener.js.map