"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseClientOptions = parseClientOptions;
var _tls_settings_provider = require("../util/tls_settings_provider");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/** @internal */

/**
 * Parse the client options from given data source config and endpoint
 *
 * @param config The config to generate the client options from.
 * @param endpoint endpoint url of data source
 */
function parseClientOptions(config, endpoint, registeredSchema) {
  const sslConfig = {
    rejectUnauthorized: true
  };
  if (config.ssl) {
    var _config$ssl;
    const verificationMode = config.ssl.verificationMode;
    switch (verificationMode) {
      case 'none':
        sslConfig.rejectUnauthorized = false;
        break;
      case 'certificate':
        sslConfig.rejectUnauthorized = true;

        // by default, NodeJS is checking the server identify
        sslConfig.checkServerIdentity = () => undefined;
        break;
      case 'full':
        sslConfig.rejectUnauthorized = true;
        break;
      default:
        throw new Error(`Unknown ssl verificationMode: ${verificationMode}`);
    }
    const {
      certificateAuthorities
    } = (0, _tls_settings_provider.readCertificateAuthorities)((_config$ssl = config.ssl) === null || _config$ssl === void 0 ? void 0 : _config$ssl.certificateAuthorities);
    sslConfig.ca = certificateAuthorities;
  }

  // for now, we only use part of the default opensearch client configs, may onboard more in the future
  const configOptions = {
    host: endpoint,
    ssl: sslConfig,
    plugins: registeredSchema,
    requestTimeout: config.globalOpenSearchConfig.requestTimeout.asMilliseconds(),
    pingTimeout: config.globalOpenSearchConfig.pingTimeout.asMilliseconds()
  };
  return configOptions;
}