"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createValidateQuerySchema = createValidateQuerySchema;
exports.isIndexNotFoundError = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toCamel = void 0;
var _lodash = require("lodash");
var _configSchema = require("@osd/config-schema");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const isIndexNotFoundError = err => {
  return err.statusCode === 404 && (0, _lodash.get)(err, 'body.error.reason', '') === 'Configured indices are not found: [.opendistro-alerting-config]';
};
exports.isIndexNotFoundError = isIndexNotFoundError;
function createValidateQuerySchema(dataSourceEnabled, fields = {}) {
  // Extend the query schema with the specified fields
  const schemaObj = {
    ...fields
  };
  if (dataSourceEnabled) {
    schemaObj['dataSourceId'] = _configSchema.schema.string();
  }
  return _configSchema.schema.object(schemaObj);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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