"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class GeospatialService {
  constructor(driver) {
    _defineProperty(this, "uploadGeojson", async (context, req, res) => {
      const dataSourceRefId = req.query.dataSourceId;
      let uploadResponse;
      try {
        if (dataSourceRefId) {
          const remoteDataSourceClient = context.dataSource.opensearch.legacy.getClient(dataSourceRefId).callAPI;
          uploadResponse = await remoteDataSourceClient('geospatial.geospatialQuery', {
            body: req.body
          });
        } else {
          const {
            callAsCurrentUser
          } = await this.driver.asScoped(req);
          uploadResponse = await callAsCurrentUser('geospatial.geospatialQuery', {
            body: req.body
          });
        }
        return res.ok({
          body: {
            ok: true,
            resp: uploadResponse
          }
        });
      } catch (err) {
        return res.ok({
          body: {
            ok: false,
            resp: err.message
          }
        });
      }
    });
    this.driver = driver;
  }
}
exports.default = GeospatialService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJHZW9zcGF0aWFsU2VydmljZSIsImNvbnN0cnVjdG9yIiwiZHJpdmVyIiwiX2RlZmluZVByb3BlcnR5IiwiY29udGV4dCIsInJlcSIsInJlcyIsImRhdGFTb3VyY2VSZWZJZCIsInF1ZXJ5IiwiZGF0YVNvdXJjZUlkIiwidXBsb2FkUmVzcG9uc2UiLCJyZW1vdGVEYXRhU291cmNlQ2xpZW50IiwiZGF0YVNvdXJjZSIsIm9wZW5zZWFyY2giLCJsZWdhY3kiLCJnZXRDbGllbnQiLCJjYWxsQVBJIiwiYm9keSIsImNhbGxBc0N1cnJlbnRVc2VyIiwiYXNTY29wZWQiLCJvayIsInJlc3AiLCJlcnIiLCJtZXNzYWdlIiwiZXhwb3J0cyIsImRlZmF1bHQiLCJtb2R1bGUiXSwic291cmNlcyI6WyJnZW9zcGF0aWFsX3NlcnZpY2UuanMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBHZW9zcGF0aWFsU2VydmljZSB7XG4gIGNvbnN0cnVjdG9yKGRyaXZlcikge1xuICAgIHRoaXMuZHJpdmVyID0gZHJpdmVyO1xuICB9XG5cbiAgdXBsb2FkR2VvanNvbiA9IGFzeW5jIChjb250ZXh0LCByZXEsIHJlcykgPT4ge1xuICAgIGNvbnN0IGRhdGFTb3VyY2VSZWZJZCA9IHJlcS5xdWVyeS5kYXRhU291cmNlSWQ7XG4gICAgbGV0IHVwbG9hZFJlc3BvbnNlO1xuICAgIHRyeSB7XG4gICAgICBpZiAoZGF0YVNvdXJjZVJlZklkKSB7XG4gICAgICAgIGNvbnN0IHJlbW90ZURhdGFTb3VyY2VDbGllbnQgPSBjb250ZXh0LmRhdGFTb3VyY2Uub3BlbnNlYXJjaC5sZWdhY3kuZ2V0Q2xpZW50KFxuICAgICAgICAgIGRhdGFTb3VyY2VSZWZJZFxuICAgICAgICApLmNhbGxBUEk7XG4gICAgICAgIHVwbG9hZFJlc3BvbnNlID0gYXdhaXQgcmVtb3RlRGF0YVNvdXJjZUNsaWVudCgnZ2Vvc3BhdGlhbC5nZW9zcGF0aWFsUXVlcnknLCB7XG4gICAgICAgICAgYm9keTogcmVxLmJvZHksXG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgY29uc3QgeyBjYWxsQXNDdXJyZW50VXNlciB9ID0gYXdhaXQgdGhpcy5kcml2ZXIuYXNTY29wZWQocmVxKTtcbiAgICAgICAgdXBsb2FkUmVzcG9uc2UgPSBhd2FpdCBjYWxsQXNDdXJyZW50VXNlcignZ2Vvc3BhdGlhbC5nZW9zcGF0aWFsUXVlcnknLCB7XG4gICAgICAgICAgYm9keTogcmVxLmJvZHksXG4gICAgICAgIH0pO1xuICAgICAgfVxuXG4gICAgICByZXR1cm4gcmVzLm9rKHtcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgIHJlc3A6IHVwbG9hZFJlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICByZXR1cm4gcmVzLm9rKHtcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICByZXNwOiBlcnIubWVzc2FnZSxcbiAgICAgICAgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRWUsTUFBTUEsaUJBQWlCLENBQUM7RUFDckNDLFdBQVdBLENBQUNDLE1BQU0sRUFBRTtJQUFBQyxlQUFBLHdCQUlKLE9BQU9DLE9BQU8sRUFBRUMsR0FBRyxFQUFFQyxHQUFHLEtBQUs7TUFDM0MsTUFBTUMsZUFBZSxHQUFHRixHQUFHLENBQUNHLEtBQUssQ0FBQ0MsWUFBWTtNQUM5QyxJQUFJQyxjQUFjO01BQ2xCLElBQUk7UUFDRixJQUFJSCxlQUFlLEVBQUU7VUFDbkIsTUFBTUksc0JBQXNCLEdBQUdQLE9BQU8sQ0FBQ1EsVUFBVSxDQUFDQyxVQUFVLENBQUNDLE1BQU0sQ0FBQ0MsU0FBUyxDQUMzRVIsZUFDRixDQUFDLENBQUNTLE9BQU87VUFDVE4sY0FBYyxHQUFHLE1BQU1DLHNCQUFzQixDQUFDLDRCQUE0QixFQUFFO1lBQzFFTSxJQUFJLEVBQUVaLEdBQUcsQ0FBQ1k7VUFDWixDQUFDLENBQUM7UUFDSixDQUFDLE1BQU07VUFDTCxNQUFNO1lBQUVDO1VBQWtCLENBQUMsR0FBRyxNQUFNLElBQUksQ0FBQ2hCLE1BQU0sQ0FBQ2lCLFFBQVEsQ0FBQ2QsR0FBRyxDQUFDO1VBQzdESyxjQUFjLEdBQUcsTUFBTVEsaUJBQWlCLENBQUMsNEJBQTRCLEVBQUU7WUFDckVELElBQUksRUFBRVosR0FBRyxDQUFDWTtVQUNaLENBQUMsQ0FBQztRQUNKO1FBRUEsT0FBT1gsR0FBRyxDQUFDYyxFQUFFLENBQUM7VUFDWkgsSUFBSSxFQUFFO1lBQ0pHLEVBQUUsRUFBRSxJQUFJO1lBQ1JDLElBQUksRUFBRVg7VUFDUjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPWSxHQUFHLEVBQUU7UUFDWixPQUFPaEIsR0FBRyxDQUFDYyxFQUFFLENBQUM7VUFDWkgsSUFBSSxFQUFFO1lBQ0pHLEVBQUUsRUFBRSxLQUFLO1lBQ1RDLElBQUksRUFBRUMsR0FBRyxDQUFDQztVQUNaO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBbkNDLElBQUksQ0FBQ3JCLE1BQU0sR0FBR0EsTUFBTTtFQUN0QjtBQW1DRjtBQUFDc0IsT0FBQSxDQUFBQyxPQUFBLEdBQUF6QixpQkFBQTtBQUFBMEIsTUFBQSxDQUFBRixPQUFBLEdBQUFBLE9BQUEsQ0FBQUMsT0FBQSJ9